/************************************************************************************
			VARIATION DE VITESSE D'UNE MAS
			COMMANDE DE MLI TRIPHASEE
			UTILISATION DU SA828     
/************************************************************************************/
/* 	Aprs initialisation du microconcrleur puis du SA828, le programme principal
/* excute une boucle sans fin. Toutes les 39ms la frquence et l'amplitude de la
/* tension sont ractualises puis une conversion est lance.
/************************************************************************************
	- frquence : entre analogique ADC0
	- sens de rotation : P1.1 
							
/************************************************************************************/
#pragma rom(small) 
#include <reg752.h>
#define ADC0 0x28             /* lecture sur la voie 0 de l'ADC */

/************************************************************************************/
/*		Dfinition des variables					    */
/************************************************************************************/
sbit AVAR = P1^1 ;		/* tat de l'inverseur AVAR (P1.1)*/
bit  sens_rot;			/* sens de rotation en cours */
sbit RESETBAR = P1^4 ;		/* reset su SA828 */
sbit ALE = P1^5 ;		/* commande du SA828 (validation des adresses) */
sbit WRBAR = P1^6 ;		/* commande du SA828 (criture) */
char vitesse=0;			/* vitesse en cours */
char vitesse_fin=0;		/* vitesse finale */
code extern char table[];	/* table de conversion frquence amplitude */ 
/************************************************************************************/
/*		Initialisation du microcontrleur				            */
/************************************************************************************/
void initialisation (void)
{
sens_rot=AVAR;		/* acquisition du sens de rotation */
TCON=0x10;              /* Timer 0 en compteur  rechargement */
RTH=0xB3;		/* interruption du timer toutes 19,5ms */
RTL=0xD4;
ET0 = 1;		/* autoriser l'interruption du timer 0 */
EAD = 1;		/* autorisation de l'interruption de l'ADC */
EA = 1;			/* autorisation des interruptions*/
}

/************************************************************************************/
/*		Sous-programme d'criture dans un registre du SA828
/************************************************************************************/
void	ecrire (char adresse,char donnee)
{
ALE = 1;
P3 = adresse;	/* adresser le registre choisi */
ALE = 0;
WRBAR = 0;
P3 = donnee;	/* crire la donne dans le registre */
WRBAR = 1;
}

/************************************************************************************/
/*		Initialisation du SA828				            */
/************************************************************************************/
void initsa828 (void)
{
RESETBAR = 0;			/* raz du SA828 */
ALE = 0;			/* initialisation du bus de commande */
WRBAR = 1;
P3 = 0xFF;			/* initialisation du bus de donne et d'adresse */

/****************** crire R0 = 0xFD  R1 = 0xA4  R2 = 0xFF *************************/
ecrire(0,0xFD);			
ecrire(1,0xA4);
ecrire(2,0xFF);
ecrire(4,0);			 
/******************** crire R0 = R1 = R2 = 0 *************************************/			 
ecrire(0,0);			
ecrire(1,0);
ecrire(2,0);
ecrire(3,0);
/******************** validation du SA828 **********************************/
RESETBAR = 1;			
}
	
/************************************************************************************/
/*		Interruption de l'ADC					            */
/************************************************************************************/
void	it_adc(void)	interrupt 5	using 1
{
vitesse_fin=ADAT;		/* modifie la vitesse finale */
}

/************************************************************************************/
/*		Interruption du timer 0		
/* La valeur de la vitesse est incrmente ou dcrmente toutes les 39ms ce qui correspond 
/*  une rampe de 256*39ms=10s.			            */
/************************************************************************************/

void	it_timer0(void)	interrupt 1		using 1
{
/************************************************************************************/
/*	Dcrementer ou incrmenter la valeur de la vitesse toutes les 39ms
/* jusqu' ce que la valeur finale soit atteinte 
/************************************************************************************/
if(vitesse<vitesse_fin)		/* incrmnter ou dcrmenter */
	vitesse++;			/* la vitesse  chaque interruption */
if(vitesse>vitesse_fin)
	vitesse--;

/************************************************************************************/
/*	Ecrire la nouvelle vitesse et l'amplitude correspondante
/************************************************************************************/

/**************************** crire dans R0 ********************************/
ecrire(0,vitesse<<4);				

/***************************** crire dans R1 ********************************/
if(vitesse<0x10)				
	sens_rot=AVAR;			/* ne valider l'inversion que si la vitesse est faible*/
if(sens_rot)					
	ecrire(1,((vitesse>>4)|0xA0));  /* test du sens de rotation */
else
	ecrire(1,((vitesse>>4)|0x20));	

/******************************* crire dans R2 ******************************/
ecrire(2,table[vitesse]);

/************************ validation des registres de commande ***************/
ecrire(3,0);

/****************************lancer une nouvelle conversion*********************/
ADCON=0;
ADCON=ADC0;					
}
    
/************************************************************************************/
/*		Programme principal 					            */
/************************************************************************************/
void main (void)                      
{
initialisation () ;		/* appel du SP d'initialisation du contrleur*/
initsa828();			/* appel du SP d'initialisation du SA828 */
while(1) ;			/* boucle sans fin */
}

