
;TITLE   "A/D in Sleep Mode"
;This program is a simple implementation of the PIC16C71's
;A/D feature. This program demonstrates
;how to do a a/d in sleep mode on the PIC16C71.
;The A/D is configured as follows:
;       Vref = +5V internal.
;       A/D Osc. = internal RC
;       A/D Interrupt = OFF
;       A/D Channels = ch 0
;
;The ch0 A/D result is displayed as a 8 bit binary value 
;on 8 leds connected to port b. Hardware used is that of
;the PICDEMO board.
;
;
;       Program:          SLPAD.ASM 
;       Revision Date:   
;                         1-14-97      Compatibility with MPASMWIN 1.40
;
;
	LIST P=16C71
        ERRORLEVEL -302
;
	include "p16c71.inc"
;
TEMP    EQU     10h
adif    equ     1
adgo    equ     2
;
;
	ORG     0x00
;
;
	goto    start
;
	org     0x04
	goto    service_int      ;interrupt vector
;
;
	org     0x10
start
	movlw   B'00000000'     ;make port b all
	movwf   PORTB          ;outputs.
;	tris    PORTB          ;       /
        BSF     STATUS, RP0     ; Bank1
        MOVWF   TRISB           ; PortB as outputs
        BCF     STATUS, RP0     ; Bank0
;
	call    InitializeAD   
update      
	movf    ADRES,W
	movwf   PORTB          ;save in table
	call    SetupDelay      ;
	bcf     ADCON0,adif     ;clr a/d flag
	bsf     ADCON0,adgo     ;start new a/d conversion
;
	sleep
	goto    update          ;wake up and update
;
service_int
	return                  ;do not enable int
;
;InitializeAD, initializes and sets up the A/D hardware.
InitializeAD
	bsf     STATUS,5        ;select pg1
	movlw   B'00000000'     ;select ch0-ch3...
	movwf   ADCON1          ;as analog inputs
	bcf     STATUS,5        ;select pg0
	movlw   B'11000001'     ;select:internal RC, ch0.
	movwf   ADCON0          ;turn on a/d
	clrf    INTCON          ;clear all interrupts
	bsf     INTCON,ADIE     ;enable a/d
	return
;
;This routine is a software delay of 10uS for the a/d setup.
;At 4Mhz clock, the loop takes 3uS, so initialize TEMp with
;a value of 3 to give 9uS, plus the move etc should result in
;a total time of > 10uS.
SetupDelay
	movlw   .3
	movwf   TEMP
SD
	decfsz  TEMP, F
	goto    SD
	return

;

	END

