;TITLE   "Single channel A/D (SAD)"
;This program is a simple implementation of the PIC16C71's
;A/D. 1 Channel is selected (CH0).
;The A/D is configured as follows:
;       Vref = +5V internal.
;       A/D Osc. =  internal RC
;       A/D Channel = CH0
;Hardware for this program is the PICDEMO board.
;
;
;       Program:          SAD.ASM 
;       Revision Date:   
;                         1-14-97      Compatibility with MPASMWIN 1.40
;
;
	LIST P=16C71
        ERRORLEVEL  -302
;
	include "p16c71.inc"
;
TEMP    EQU     10h
adif    equ     1
adgo    equ     2
;
	ORG     0x00
;
;
	goto    start
;
	org     0x04
	goto    service_int      ;interrupt vector
;
;
	org     0x10
start
	movlw   B'00000000'     ;set port b as
	movwf   PORTB          ;all outputs
;	tris    PORTB          ;       /
        BSF     STATUS, RP0     ; Bank1
        MOVWF   TRISB           ; PortB as outputs
        BCF     STATUS, RP0     ; Bank0
;
	call    InitializeAD   
update      
	movf    ADRES,W         ;get a/d value
	movwf   PORTB          ;output to port b
	call    SetupDelay      ;setup time >= 10uS.
	bcf     ADCON0,adif     ;clear int flag
	bsf     ADCON0,adgo     ;start new conversion
loop
	btfsc   ADCON0,adif     ;a/d done?
	goto    update          ;yes then update new value.
	goto    loop            ;no then keep checking
;
;no interrupts are enabled, so if the program ever reaches here,
;it should be returned with the global interrupts disabled.
service_int
	return                  ;do not enable global.
;
;
;
;InitializeAD, initializes and sets up the A/D hardware.
;Select ch0 to ch3 as analog inputs, fosc/2 and read ch3.
;
InitializeAD
	bsf     STATUS,5        ;select pg1
	movlw   B'00000000'     ;select ch0-ch3...
	movwf   ADCON1          ;as analog inputs
	bcf     STATUS,5        ;select pg0
	movlw   B'11000001'     ;select:RC,ch0..
	movwf   ADCON0          ;turn on A/D.
	clrf    ADRES           ;clr result reg.
	return
;
;This routine is a software delay of 10uS for the a/d setup.
;At 4Mhz clock, the loop takes 3uS, so initialize TEMp with
;a value of 3 to give 9uS, plus the move etc should result in
;a total time of > 10uS.
SetupDelay
	movlw   .3
	movwf   TEMP
SD
	decfsz  TEMP, F
	goto    SD
	return


	END

