;TITLE   "A/D using Multiple Channels"
;This program is a simple implementation of the PIC16C71's
;A/D feature. This program demonstrates
;how to select multiple channels on the PIC16C71.
;The A/D is configured as follows:
;       Vref = +5V internal.
;       A/D Osc. = internal RC osc.
;       A/D Interrupt = Off
;       A/D Channels = all in a "Round Robin" format.
;       A/D reuslts are stored in ram locations as follows:
;       ch0 --> ADTABLE + 0
;       ch1 --> ADTABLE + 1
;       ch2 --> ADTABLE + 2
;       ch3 --> ADTABLE + 3
;
;The ch0 A/D result is displayed as a 8 bit value on 8 leds  
;connected to port b. 
;Hardware: PICDEMO board.
;               Stan D'Souza 7/6/93.
;
;       Program:          MULTAD.ASM 
;       Revision Date:   
;                         1-14-97      Compatibility with MPASMWIN 1.40
;
;
	LIST P=16C71
        ERRORLEVEL  -302
;
	include "p16c71.inc"
;
TEMP    EQU     10h
adif    equ     1
adgo    equ     2
;
ch2     equ     6
ch3     equ     7
flag    equ     0C
ADTABLE equ     20
;
	ORG     0x00
;
;
	goto    start
;
	org     0x04
	goto    service_int      ;interrupt vector
;
;
	org     0x10
start
	movlw   B'00000000'     ;make port b 
	movwf   PORTB          ;as all outputs
;	tris    PORTB          ;       /
        BSF     STATUS, RP0     ; Bank1
        MOVWF   TRISB           ; PortB as outputs
        BCF     STATUS, RP0     ; Bank0
;
	call    InitializeAD   
update      
	movf    ADRES,W
	movwf   0               ;save in table
	movlw   ADTABLE         ;chk if ch0
	subwf   FSR,W           ;     /
	btfss   STATUS,Z        ;yes then skip
	goto    NextAd          ;else do next channel
	movf    ADRES,W         ;get a/d value
	movwf   PORTB          ;output to port b
NextAd
	call    NextChannel     ;select next channel
	call    SetupDelay      ;set up > = 10uS
	bcf     ADCON0,adif     ;clear flag
	bsf     ADCON0,adgo     ;start new a/d conversion
loop
	btfsc   ADCON0,adif     ;a/d done?
	goto    update          ;yes then update
	goto    loop            ;wait till done
;
service_int
	return                  ;do not enable int
;
;
;InitializeAD, initializes and sets up the A/D hardware.
InitializeAD
	bsf     STATUS,5        ;select pg1
	movlw   B'00000000'     ;select ch0-ch3...
	movwf   ADCON1          ;as analog inputs
	bcf     STATUS,5        ;select pg0
	movlw   B'11000001'     ;select:fosc/2, ch0.
	movwf   ADCON0          ;turn on a/d
	movlw   ADTABLE         ;get top of table address
	movwf   FSR             ;load into indirect reg
	clrf    ADRES           ;clr result reg.
	return
;
;NextChannel, selects the next channel to be sampled in a 
;"round-robin" format.
NextChannel
	movlw   0x08            ;get channel offset
	addwf   ADCON0, F       ;add to conf. reg.
	bcf     ADCON0,5        ;clear any carry over
;increment pointer to correct a/d result register
	clrf    TEMP
	btfsc   ADCON0,3        ;test lsb of chnl select
	bsf     TEMP,0          ;set if ch1 or ch3
	btfsc   ADCON0,4        ;test msb of chnl select
	bsf     TEMP,1          ;set if ch0 or ch2
	movlw   ADTABLE         ;get top of table
	addwf   TEMP,W          ;add with temp
	movwf   FSR             ;allocate new address
	return
;
;This routine is a software delay of 10uS for the a/d setup.
;At 4Mhz clock, the loop takes 3uS, so initialize TEMp with
;a value of 3 to give 9uS, plus the move etc should result in
;a total time of > 10uS.
SetupDelay
	movlw   .3
	movwf   TEMP
SD
	decfsz  TEMP, F
	goto    SD
	return

;

	END

