
;TITLE	 "Single channel A/D with interrupts"
;This program is a simple implementation of the PIC16C71's
;A/D. 1 Channel is selected (CH0). A/D interrupt is turned on,
;hence on completion of a/d conversion, an interrupt is generated.
;The A/D is configured as follows:
;       Vref = +5V internal.
;       A/D Osc. = internal RC Osc.
;       A/D Interrupt = On
;       A/D Channel = CH0
;
;The A/D result is displayed as a 8 bit value on 8 leds connected 
;to port b. Hardware setup is the PICDEMO board.
;
;
;       Program:          INTAD.ASM 
;       Revision Date:   
;                         1-14-97      Compatibility with MPASMWIN 1.40
;
;
	LIST P=16C71
        ERRORLEVEL  -302
;
	include "p16c71.inc"
;
flag    equ     10
TEMP    equ     11
adover  equ     0
adif    equ     1
adgo    equ     2
adie    equ     6
gie     equ     7          
rp0     equ     5
;
	ORG     0x00
;
;
	goto    start
;
	org     0x04
	goto    service_ad      ;interrupt vector
;
;
	org     0x10
start
	movlw   B'00000000'     ;init i/o ports
	movwf   PORTB
;	tris    PORTB
        BSF     STATUS, RP0     ; Bank1
        MOVWF   TRISB           ; PortB as outputs
        BCF     STATUS, RP0     ; Bank0
;
	call    InitializeAD   
update      
	bcf     flag,adover     ;reset software a/d flag
	call    SetupDelay      ;setup delay >= 10uS.
	bcf     ADCON0,adif     ;reset a/d int flag (ADIF)
	bsf     ADCON0,adgo     ;start new a/d conversion
	bsf     INTCON,gie      ;enable global interrupt
loop
	btfsc   flag,adover     ;a/d over?
	goto    update          ;yes start new conv.
	goto    loop            ;no then keep checking
;
service_ad
	btfss   ADCON0,adif     ;ad interrupt?
	retfie                  ;no then ignore
	movf    ADRES,W         ;get a/d value
	movwf   PORTB          ;output to port b
	bsf     flag,adover     ;a/d done set
	return                  ;do not enable int
;
;
;InitializeAD, initializes and sets up the A/D hardware.
;select ch0 to ch3, RC OSC., a/d interrupt.
InitializeAD
	bsf     STATUS,rp0      ;select pg1
	movlw   B'00000000'     ;select ch0-ch3...
	movwf   ADCON1          ;as analog inputs
	bcf     STATUS,rp0      ;select pg0
	clrf    INTCON          ;clr all interrupts
	bsf     INTCON,adie     ;enable a/d int.
	movlw   B'11000001'     ;select:RC osc,ch0...
	movwf   ADCON0          ;turn on a/d
	return
;
;This routine is a software delay of 10uS for the a/d setup.
;At 4Mhz clock, the loop takes 3uS, so initialize TEMp with
;a value of 3 to give 9uS, plus the move etc should result in
;a total time of > 10uS.
SetupDelay
	movlw   .3
	movwf   TEMP
SD
	decfsz  TEMP, F
	goto    SD
	return
;
;
	END

