/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  wwdg.c
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. THE AUTHOR 
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  

#include "lib.h"		/* General purpose typedefs and macros */
#include "ST7MC_hr.h"
#include "wwdg.h"		/* Public Window watchdog function prototypes */


#define WDG_TIMEOUT		80		// 80 ms timeout


volatile u8 Timer_WDG;


BOOL WWD_Init(void)
{
	//	if LVD or WWD reset, wait for user's reset (to be discussed)
	// if (SICSR & (LVDRF+WDRF) return(FALSE);
	WWDGCR = WDGA + 0x7F;	// Starts the Window watchdog and load it to its max value
	WWDGWR	= 0x5B;				// Refresh window is between 72 and 128ms (100ms+/-28ms)
	Timer_WDG = WDG_TIMEOUT;
	return(TRUE);
}


void WWD_Refresh(void)
{
	WWDGCR = WDGA + 0x7F;	// Reload Window watchdog with max value
	Timer_WDG = WDG_TIMEOUT;
}

  
BOOL Chk_Timer_WDG_Elapsed(void)
{
if (Timer_WDG == 0) return(TRUE);
else return(FALSE);
}


/*** (c) 2006  **************************** END OF FILE ***/