/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  vector.c
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Interrupt service routines prototypes  
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. THE AUTHOR 
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  

extern void dummy_rt(void);
extern void ART_Interrupt (void);
extern void AVD_Interrupt (void);
extern void SCI_IT_Routine (void);
extern void TIMB_Interrupt (void);
extern void TIMA_Interrupt (void);
extern void dummy_rt (void);
extern void PORTS_2_Interrupt (void);
extern void PORTS_1_Interrupt (void);
extern void PORTS_0_Interrupt (void);
extern void MCC_Interrupt (void);
extern void MCES_SE_IT (void);
extern void TRAP_Interrupt (void);
extern void MTC_U_CL_SO_IT (void);
extern void _stext(void);


// Interrupt service routines vector table (unused vectors point to Dummy int (iret)

volatile void (*const _vectab[])() = {
		ART_Interrupt,		    // ART_Interrupt, 
		AVD_Interrupt,			// AVD_Interrupt,
		SCI_IT_Routine,			// SCI_IT_Routine,
		TIMB_Interrupt,			// TIMB_Interrupt,
		TIMA_Interrupt,			// TIMA_Interrupt,
		dummy_rt,			// SPI_Interrupt,
		dummy_rt,             // Event C or D
		dummy_rt,             // Event R or Z
		MTC_U_CL_SO_IT,         // Event U or Current Loop or Sampling Out
		PORTS_2_Interrupt,		// PORTS_2_Interrupt,
		PORTS_1_Interrupt,		// PORTS_1_Interrupt,
		PORTS_0_Interrupt,		// PORTS_0_Interrupt,
		MCC_Interrupt,			// MCC_Interrupt,
		MCES_SE_IT,
		TRAP_Interrupt,			// TRAP_Interrupt,
		_stext
		};

/*** (c) 2004 STMicroelectronics ****************** END OF FILE ***/

