/**************** (c) 2006 Florent COSTE **********************

PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  ports.h
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :  I/O line control routine prototypes

              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

******************************************************************************/

#ifndef PORTS7_H
#define PORTS7_H

/*----------------------------- Exported functions --------------------------*/

void PORTS_Init(void);
void toggle_PA1(void);
void key_scan(void);
void Key_Menu_0(void);
void Key_Menu_Discharge(void);
void Key_Menu_Timeout(void);
void Key_Menu_Check_Battery_Connected(void);
void Key_Menu_Wait_For_Charge(void);
void Key_Menu_Charge(void);

/*----------------------------- Exported constants --------------------------*/
#define Port_A		0x00
#define Port_B		0x03
#define Port_C		0x06
#define Port_D		0x09
#define Port_E		0x0C

#define LED (Port_B * 8 + 7 - 6)    

/*----------------------------- Exported variable --------------------------*/
typedef enum 
{
MENU_0, MENU_1, MENU_2, WAIT_FOR_CHARGE, END_CHARGE, END_DISCHARGE, CHARGE_INTERRUPTED, MENU_CALIB_1, MENU_CALIB_2, CHARGE_NIMH, CHARGE_LIPO_PHASE_1, CHARGE_LIPO_PHASE_2, DISCHARGE_1, DISCHARGE_2,CHECK_BATTERY_CONNECTED, TIMEOUT, OVERTEMP
} SystStatus_t;

extern SystStatus_t State;

typedef enum 
{
BEEP_OFF,BEEP_ON
} SystBeep_t;

extern SystBeep_t BeepState;


extern u8 Key_Flag;
#define Key_Function_Plus				0
#define Key_Data_Plus						1
#define Key_Function_Minus			2
#define Key_Data_Minus					3
#define Key_Function_Plus_rpt		4
#define Key_Data_Plus_rpt				5
#define Key_Function_Minus_rpt	6
#define Key_Data_Minus_rpt			7

#define Key_Function_Plus_MSK				0x01
#define Key_Data_Plus_MSK						0x02
#define Key_Function_Minus_MSK			0x04
#define Key_Data_Minus_MSK					0x08
#define Key_Function_Plus_rpt_MSK		0x0a
#define Key_Data_Plus_rpt_MSK				0x20
#define Key_Function_Minus_rpt_MSK	0x40
#define Key_Data_Minus_rpt_MSK			0x80


extern u8 LED_ON_Time,Beep_Timer,Beep_Number;

void Led(void);
void Buzzer(void);

#endif
/**************** (c) 2006 Florent COSTE **********************/

