/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  ports.c
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : I/O line control routines
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. THE AUTHOR 
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  
                           
#include "lib.h"
#include "ST7MC_hr.h"
#include "it_ST7MC.h"
#include "misc.h"
#include "lcd.h"
#include "i2c.h"
#include "adc.h"
#include "mtc.h"
#include "mtc_hr.h"
#include "MTC_Settings_Sensorless.h"
#include "ports.h"

u8 Key_Flag;
#define Key_Thresold_high	0x80
#define Key_Thresold_Low	0x0a

typedef enum 
{
KEY_RELEASED, KEY_PUSHED, KEY_REPEAT, KEY_IDLE_1, KEY_IDLE_2
} SystStatus_key;
static SystStatus_key Key_State = KEY_RELEASED;

SystStatus_t State;

SystBeep_t BeepState;

u8 LED_ON_Time, Beep_Number, Beep_Timer;

/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_Init
INPUT/OUTPUT : None

DESCRIPTION  : Configure the ports

COMMENTS     :
-----------------------------------------------------------------------------*/
void PORTS_Init(void)           // Setting for 56 pins case of Starter kit
{

	PADDR    = 0x00;       	// PA0-7 all input
	PAOR	 = 0x00;       	

  PBDDR    = 0x51; 	 // PB6 output open drain
	PBOR     = 0x11;        // PB0, PB4 push-pull Output low level 
	SET_MUX_All_OFF;
	SetBit(PBDR,6);
		
	PDDDR    = 0xcf; 	// PD0-3 PD6 push-pull Output 
	PDOR     = 0x4f;	// PD7 open drain
	PDDR	 = 0xc0;	// PD6-7 high level
	    
	PEDDR    = 0x0f; 	// PE0-3 push-pull Output 
	PEOR     = 0x0f;	// 
	PEDR	 = 0x00;	// low level 
	    
}



/*-----------------------------------------------------------------------------
ROUTINE Name :  key_scan
Description :  check if button is pushed or released
-----------------------------------------------------------------------------*/ 
void key_scan(void)
{
if (DebounceButton == 0)
	{
	DebounceButton = 50;	// 100 ms debouncing
	
	if (ADC_Get_8bits(CONVERT_AIN1) <= Key_Thresold_Low)	
		{
			if (!ValBit(Key_Flag,Key_Data_Plus))	
				{
				SetBit(Key_Flag,Key_Data_Plus); 
				Key_Data_Plus_rpt_counter = 50;	// 500ms tempo
				}
			if (Key_Data_Plus_rpt_counter == 0) 
				{
				SetBit(Key_Flag,Key_Data_Plus_rpt);
				Key_Data_Plus_rpt_counter = 35;	// 250ms tempo
				}
		}
	else	
		{
		ClrBit(Key_Flag,Key_Data_Plus); 
		ClrBit(Key_Flag,Key_Data_Plus_rpt); 
		
		if (ADC_Get_8bits(CONVERT_AIN1) <= Key_Thresold_high)	
			{
			if (!ValBit(Key_Flag,Key_Function_Minus))	
				{
				SetBit(Key_Flag,Key_Function_Minus); 
				Key_Function_Minus_rpt_counter = 50;	// 500ms tempo
				}
			if (Key_Function_Minus_rpt_counter == 0) 
				{
				SetBit(Key_Flag,Key_Function_Minus_rpt);
				Key_Function_Minus_rpt_counter = 35;	// 250ms tempo
				}
			}
		else	
			{
			ClrBit(Key_Flag,Key_Function_Minus); 
			ClrBit(Key_Flag,Key_Function_Minus_rpt); 
			}
		}

	if (ADC_Get_8bits(CONVERT_AIN3)<=Key_Thresold_Low)	
		{
		if (!ValBit(Key_Flag,Key_Function_Plus))	
			{
			SetBit(Key_Flag,Key_Function_Plus); 
			Key_Function_Plus_rpt_counter = 50;	// 500ms tempo
			}
		if (Key_Function_Plus_rpt_counter == 0) 
			{
			SetBit(Key_Flag,Key_Function_Plus_rpt);
			Key_Function_Plus_rpt_counter = 35;	// 250ms tempo
			}
		}
	else	
		{
		ClrBit(Key_Flag,Key_Function_Plus); 
		ClrBit(Key_Flag,Key_Function_Plus_rpt); 

		if (ADC_Get_8bits(CONVERT_AIN3)<=Key_Thresold_high) 
			{
			if (!ValBit(Key_Flag,Key_Data_Minus))	
				{
				SetBit(Key_Flag,Key_Data_Minus); 
				Key_Data_Minus_rpt_counter = 50;	// 500ms tempo
				}
			if (Key_Data_Minus_rpt_counter == 0) 
				{
				SetBit(Key_Flag,Key_Data_Minus_rpt);
				Key_Data_Minus_rpt_counter = 35;	// 350ms tempo
				}
			}
		else	
			{
			ClrBit(Key_Flag,Key_Data_Minus); 
			ClrBit(Key_Flag,Key_Data_Minus_rpt); 
			}
		}
	}
}


Process_Blinking(u8 menu_idx)
{
switch(menu_idx)
	{
	default:
	case 0:
		Blinking_Flag_line1 = 0xffff;	// no blinking
		Blinking_Flag_line2 = 0xffff;
		break;
	case 1:
		Blinking_Flag_line1 = 0x7fff; // first model name
		Blinking_Flag_line2 = 0xffff; // character blinking
		break;
	case 2:
		Blinking_Flag_line1 = 0xbfff; // second
		Blinking_Flag_line2 = 0xffff;
		break;
	case 3:
 		Blinking_Flag_line1 = 0xdfff; // third ...
		Blinking_Flag_line2 = 0xffff;
		break;
	case 4:
		Blinking_Flag_line1 = 0xefff;
		Blinking_Flag_line2 = 0xffff;
		break;
	case 5:
		Blinking_Flag_line1 = 0xf7ff;
		Blinking_Flag_line2 = 0xffff;
		break;
	case 6:
		Blinking_Flag_line1 = 0xfbff;
		Blinking_Flag_line2 = 0xffff;
		break;
	case 7:
		Blinking_Flag_line1 = 0xfdff;
		Blinking_Flag_line2 = 0xffff;
		break;
	case 8:
		Blinking_Flag_line1 = 0xfeff;
		Blinking_Flag_line2 = 0xffff;
		break;
	case 9:
		Blinking_Flag_line1 = 0xffbf;	// sensitivity
		Blinking_Flag_line2 = 0xffff;
		break;
	case 10:
		Blinking_Flag_line1 = 0xfff0;	//  timeout
		Blinking_Flag_line2 = 0xffff;
		break;
	case 11:
		Blinking_Flag_line1 = 0xffff; // I discharge start
		if (Model.I_Discharge_Start <= DISCHARGE_OFF)	Blinking_Flag_line2 = 0x007f;	// Discg.OFF blinking
		else Blinking_Flag_line2 = 0x87ff;
		break;
	case 12:
		Blinking_Flag_line1 = 0xffff; // I discharge stop
		Blinking_Flag_line2 = 0xfc3f;
		break;
	case 13:
		Blinking_Flag_line1 = 0xffff; // I charge
		/*if (Model.I_Charge <= CHARGE_OFF)	Blinking_Flag_line2 = 0xfff8;	// Ch.OFF blinking
		else*/ Blinking_Flag_line2 = 0xfff0;
		break;
	case 14:
		Blinking_Flag_line1 = 0xff00; // LiPO?
		Blinking_Flag_line2 = 0xffff;
		break;
	case 15:
		Blinking_Flag_line1 = 0xffff; // V cut off
		if (Model.I_Discharge_Start > DISCHARGE_OFF)	Blinking_Flag_line2 = 0xff81;
		else Blinking_Flag_line2 = 0xffff;
		break;
	}	
}


void Key_Menu_0(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		if (ValBit(Key_Flag,Key_Function_Plus))
			{
			menu_index++;
			if ( (menu_index == 9) && (Model.LiPO == TRUE) ) menu_index++;
			if ( (menu_index == 10) && (Model.I_Charge <= CHARGE_OFF) ) menu_index++;
			if ( (menu_index == 12) && (Model.I_Discharge_Start <= DISCHARGE_OFF) ) menu_index++;  // no discharge?
			if ( (menu_index == 15) && (Model.I_Discharge_Start <= DISCHARGE_OFF) ) menu_index++;  // no discharge?
			if (menu_index >= 16) 
				{
				menu_index = 0;
				}
			Process_Blinking(menu_index);
			}
	
		else if (ValBit(Key_Flag,Key_Function_Minus))
			{
			menu_index--;
			if (menu_index == 255) 
				{
				menu_index = 15;
				}
			if ( (menu_index == 15) && (Model.I_Discharge_Start <= DISCHARGE_OFF) ) menu_index--;  // no discharge?
			if ( (menu_index == 12) && (Model.I_Discharge_Start <= DISCHARGE_OFF) ) menu_index--;  // no discharge?
			if ( (menu_index == 10) && (Model.I_Charge <= CHARGE_OFF) ) menu_index--;
			if ( (menu_index == 9) && (Model.LiPO == TRUE) ) menu_index--;
			Process_Blinking(menu_index);
			}
		
		if (ValBit(Key_Flag,Key_Data_Plus))
			{
			if (menu_index == 0)
				{
				u8 model_index;
				
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				
				model_index = I2c_EepBuff[2];
				if (model_index < (TOTAL_MODELS-1))	
					{
					Load_Model_Parameters(model_index+1);
					Save_Model_Parameters(model_index+1);
					}
				else 
					{
					Load_Model_Parameters(0);
					Save_Model_Parameters(0);
					}
				}
			else if (menu_index <= 8) // model name
				{
				Model.Model_Name[menu_index-1]++;
				if (Model.Model_Name[menu_index-1] > 127) Model.Model_Name[menu_index-1] = 32;
				Model_Display();
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);
				}
			else if (menu_index == 9)  // sensitivity
				{
				if (Model.Sensitivity == HIGH)	Model.Sensitivity = LOW;
				else Model.Sensitivity += 1;
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read model number
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 10)	// timeout
				{
				Model.Timeout += 10;
				if ((Model.Timeout & 0xff) >= 60) 
					{
					Model.Timeout &= 0xff00;
					Model.Timeout +=0x0100;
					}
				if (Model.Timeout >= 0x0a00) Model.Timeout = 10;
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 11)  // D start
				{
				if (Model.I_Discharge_Start < 2000) Model.I_Discharge_Start	+= 50;
				else Model.I_Discharge_Start	+= 100;
				if (Model.I_Discharge_Start > 5000)	Model.I_Discharge_Start = DISCHARGE_OFF;				if ( (Model.I_Discharge_Start == DISCHARGE_OFF)	&& (Model.I_Charge == CHARGE_OFF) )	Model.I_Discharge_Start = 200;				
				
				if (Model.I_Discharge_Stop > Model.I_Discharge_Start) Model.I_Discharge_Stop = Model.I_Discharge_Start;
				if (Model.I_Discharge_Stop <= DISCHARGE_OFF) Model.I_Discharge_Stop = 200;				
				Process_Blinking(11);
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 12)  // D stop
				{
				if (Model.I_Discharge_Stop < 2000) Model.I_Discharge_Stop	+= 50;
				else Model.I_Discharge_Stop	+= 100;
				if (Model.I_Discharge_Stop > Model.I_Discharge_Start) Model.I_Discharge_Stop = 200;				
				if (Model.I_Discharge_Stop <= DISCHARGE_OFF) Model.I_Discharge_Stop = 200;				
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 13)  // C
				{
				if (Model.I_Charge < 2000) Model.I_Charge	+= 50;
				else Model.I_Charge	+= 100;
				if (Model.I_Charge > 4500)	Model.I_Charge = CHARGE_OFF;				
				if ( (Model.I_Discharge_Start == DISCHARGE_OFF)	&& (Model.I_Charge == CHARGE_OFF) )	Model.I_Charge = 200;				
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 14)  // Lipo
				{
/*				if (Model.LiPO == TRUE)	Model.LiPO = FALSE;
				else Model.LiPO = TRUE;
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	*/
				if ( (Model.LiPO == TRUE)	&& (Model.LiION == FALSE) ) (Model.LiION = TRUE);
				else if ( (Model.LiPO == TRUE)	&& (Model.LiION == TRUE) ) 
					{
					(Model.LiPO = FALSE);
					(Model.LiION = FALSE);
					}
				else 
					{
					Model.LiPO = TRUE;
					Model.LiION = FALSE;
					}
				
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 15)  // Cut off V
				{
				Model.VCutoff += 1;
				if (Model.VCutoff == 81) Model.VCutoff = 5;
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			}
	
		else if (ValBit(Key_Flag,Key_Data_Minus))
			{
			if (menu_index == 0)
				{
				u8 model_index;
				
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				model_index = I2c_EepBuff[2];
				
				if (model_index > 0)	
					{
					Load_Model_Parameters(model_index-1);
					Save_Model_Parameters(model_index-1);
					}
				else 
					{
					Load_Model_Parameters(TOTAL_MODELS-1);
					Save_Model_Parameters(TOTAL_MODELS-1);
					}
				}
			else if (menu_index <= 8) // model name
				{
				Model.Model_Name[menu_index-1]--;	
				if (Model.Model_Name[menu_index-1] < 32) Model.Model_Name[menu_index-1] = 127;
				Model_Display();				
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);
				}
			else if (menu_index == 9)	// sensitivity
				{
				if (Model.Sensitivity == LOW)	Model.Sensitivity = HIGH;
				else Model.Sensitivity -= 1;
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS), 3);  // read model number
				Save_Model_Parameters(I2c_EepBuff[2]);	
				Model_Display();				
				}
			else if (menu_index == 10) // time out
				{
				Model.Timeout -= 10;
				if ((Model.Timeout & 0xff) >= 60) 
					{
					Model.Timeout &= 0xff00;
					Model.Timeout |= 0x32; // 50 minutes
					}
				if (Model.Timeout < 0x0a) Model.Timeout = 0x0932;  // 9h50min
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				Model_Display();				
				}
			else if (menu_index == 11) // D start
				{
				if (Model.I_Discharge_Start > 2000) Model.I_Discharge_Start	-= 100;
				else Model.I_Discharge_Start	-= 50;
				if ( (Model.I_Discharge_Start == DISCHARGE_OFF)	&& (Model.I_Charge == CHARGE_OFF) )	Model.I_Discharge_Start = 5000;				
				if (Model.I_Discharge_Start < DISCHARGE_OFF)	Model.I_Discharge_Start = 5000;				
				if (Model.I_Discharge_Stop > Model.I_Discharge_Start) Model.I_Discharge_Stop = Model.I_Discharge_Start;
				if (Model.I_Discharge_Stop <= DISCHARGE_OFF) Model.I_Discharge_Stop = 200;				
				Process_Blinking(11);
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 12) // D stop
				{
				if (Model.I_Discharge_Stop > 2000) Model.I_Discharge_Stop	-= 100;
				else Model.I_Discharge_Stop	-= 50;
				if (Model.I_Discharge_Stop <200) Model.I_Discharge_Stop = 5000;
				if (Model.I_Discharge_Stop > Model.I_Discharge_Start) Model.I_Discharge_Stop = Model.I_Discharge_Start;
				if (Model.I_Discharge_Stop <= DISCHARGE_OFF) Model.I_Discharge_Stop = 200;				
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 13) // C
				{
				if (Model.I_Charge > 2000) Model.I_Charge	-= 100;
				else Model.I_Charge	-= 50;
				if ( (Model.I_Discharge_Start == DISCHARGE_OFF)	&& (Model.I_Charge == CHARGE_OFF) )	Model.I_Charge = 4500;				
				if (Model.I_Charge < CHARGE_OFF)	Model.I_Charge = 4500;				
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 14)  // Lipo
				{
/*				if (Model.LiPO == TRUE)	Model.LiPO = FALSE;
				else Model.LiPO = TRUE;
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
			Save_Model_Parameters(I2c_EepBuff[2]);	*/
				if ( (Model.LiPO == TRUE)	&& (Model.LiION == TRUE) ) (Model.LiION = FALSE);
				else if ( (Model.LiPO == TRUE)	&& (Model.LiION == FALSE) ) 
					{
					(Model.LiPO = FALSE);
					(Model.LiION = FALSE);
					}
				else 
					{
					Model.LiPO = TRUE;
					Model.LiION = TRUE;
					}
					
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			else if (menu_index == 15)  // Cut off V
				{
				Model.VCutoff -= 1;
				if (Model.VCutoff == 4) Model.VCutoff = 80;  // 0.4V? -> 8.0V
				I2C_EepromRead((u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // read 3 bytes
				Save_Model_Parameters(I2c_EepBuff[2]);	
				}
			}
		Model_Display();				
		Key_State = KEY_IDLE_1;
		break;

	case KEY_IDLE_1:
		if ((Key_Flag&0xf0) != 0)	Key_State = KEY_REPEAT;
		else if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
		
	case KEY_REPEAT:
		if (ValBit(Key_Flag,Key_Function_Plus_rpt) || (ValBit(Key_Flag,Key_Function_Minus_rpt)) )	
			{
			Chk_Bat_State = BAT_CHK_WAIT_CHARGE;
			Chk_Battery_Timer = 200;  // 400 ms tempo
			Reset_RTC();
			capa = 0;
//			Set_Duty_for_Current_Ref(150);  // <>250ma charging current for battery detection
//			MTC_Charge();
			ClrBit(MCRA,3); // voltage mode
			Set_Duty_for_Current_Ref(250);  //
//			Set_Duty_for_Current_Ref(150);  //
			Set_Duty_for_Voltage_Mode(150);
			MTC_Charge();
			State = CHECK_BATTERY_CONNECTED;
			}

		if (ValBit(Key_Flag,Key_Data_Minus_rpt) || (ValBit(Key_Flag,Key_Data_Plus_rpt)) )
			{
			Key_Flag &= 0x0f;	 // reset repeat key
			Key_State = KEY_PUSHED;
			break;
			}
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}


void Key_Menu_Discharge(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		Key_State = KEY_IDLE_1;
		break;

	case KEY_IDLE_1:
		if ((Key_Flag&0xf0) != 0)	Key_State = KEY_REPEAT;
		else if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
		
	case KEY_REPEAT:
		if ( (Key_Flag&0xf0) != 0)  // any key repeat pushed?
			{
			Set_Duty_for_Current_Ref(0);  // 
			MTC_Stop_Charge_Discharge();
			if (Model.I_Charge > CHARGE_OFF) Reset_RTC();  // reset RTC only if charging process is ON
			SetBit(Flag_1,Discharge_Interrupt_By_User);
			State = WAIT_FOR_CHARGE;	
			}
		
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}



void Key_Menu_Timeout(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		if (Key_Flag != 0)  // any key repeat pushed?
			{
			Reset_Variables();
			Model_Display();  // refresh LCD buffers
			Blinking_Flag_line1 = 0xffff;
			Blinking_Flag_line2 = 0xffff;
			State = MENU_0;	
			}
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}


void Key_Menu_End_Charge(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		if (Key_Flag != 0)  // any key repeat pushed?
			{
			Reset_Variables();
			Model_Display();  // refresh LCD buffers
			Blinking_Flag_line1 = 0xffff;
			Blinking_Flag_line2 = 0xffff;
			State = MENU_0;	
			}
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}


void Key_Menu_Calibration(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		if (ValBit(Key_Flag,Key_Function_Minus) && ValBit(Key_Flag,Key_Function_Plus) )
			{
			State = MENU_CALIB_1;	
			}

		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}

				
void	Key_Menu_Calib_1(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		Key_State = KEY_IDLE_1;
		break;

	case KEY_IDLE_1:
		if ((Key_Flag&0xf0) != 0)	Key_State = KEY_REPEAT;
		else if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
		
	case KEY_REPEAT:
		if ( (Key_Flag&0xf0) != 0)  // any key repeat pushed?
			{
			State = MENU_CALIB_2;	
			}
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	

}

void	Key_Menu_Calib_2(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		Key_State = KEY_IDLE_1;
		break;

	case KEY_IDLE_1:
		if ((Key_Flag&0xf0) != 0)	Key_State = KEY_REPEAT;
		else if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
		
	case KEY_REPEAT:
		if ( (Key_Flag&0xf0) != 0)  // any key repeat pushed?
			{
			Set_Duty_for_Current_Ref(0);  // 
			MTC_Stop_Charge_Discharge();
			Reset_Variables();
			I2C_EepromRead(EEPROM_MODEL_1_BASE_ADRESS + (Model_BYTE_SIZE*TOTAL_MODELS),3);  // read last model number used before shutdown
			Load_Model_Parameters(I2c_EepBuff[2]); // load model parameters
			Model_Display();  // refresh LCD buffers
			Blinking_Flag_line1 = 0xffff;
			Blinking_Flag_line2 = 0xffff;

			State = MENU_0;	
			}
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}


void Key_Menu_Check_Battery_Connected(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		Key_State = KEY_IDLE_1;
		break;

	case KEY_IDLE_1:
		if ((Key_Flag&0xf0) != 0)	Key_State = KEY_REPEAT;
		else if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
		
	case KEY_REPEAT:
		if ( (Key_Flag&0xf0) != 0)  // any key repeat pushed?
			{
			Set_Duty_for_Current_Ref(0);  
			MTC_Stop_Charge_Discharge();
			Reset_Variables();
			Model_Display();  // refresh LCD buffers
			Blinking_Flag_line1 = 0xffff;
			Blinking_Flag_line2 = 0xffff;
			State = MENU_0;	
			}
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}


void Key_Menu_Wait_For_Charge(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		if (Key_Flag != 0)  // any key pushed?
			{
			RTC_min = 3;   // force next state (= menu_2)
			}
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}

void Key_Menu_Charge(void)
{
switch (Key_State)
	{
	case KEY_RELEASED:
		if ((Key_Flag&0x0f) != 0)	Key_State = KEY_PUSHED;
		break;

	case KEY_PUSHED:
		Key_State = KEY_IDLE_1;
		break;

	case KEY_IDLE_1:
		if ((Key_Flag&0xf0) != 0)	Key_State = KEY_REPEAT;
		else if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
		
	case KEY_REPEAT:
		if ( (Key_Flag&0xf0) != 0)  // any key repeat pushed?
			{
			Set_Duty_for_Current_Ref(0);   
			MTC_Stop_Charge_Discharge();
			RTC_Hour_Charge_Stop = RTC_hour;
			RTC_Min_Charge_Stop = RTC_min;
			State = CHARGE_INTERRUPTED;
			}
		Key_State = KEY_IDLE_2;
		break;

	default:
	case KEY_IDLE_2:
		if (Key_Flag == 0) Key_State = KEY_RELEASED;
		break;
	}	
}

void Buzzer(void)
{
if (Beep_Number>=10) return;

switch(BeepState)
	{
	default:
	case BEEP_OFF:
	if (Beep_Timer == 0)	
		{
		Beep_Timer = 200;
		BeepState = BEEP_ON;
		MTC_Stop_Charge_Discharge();
		ClrBit(MCRA,3); // voltage mode
		Set_Duty_for_Current_Ref((u16)(PWM_FREQUENCY+1));  // 
		Set_Duty_for_Voltage_Mode((u16)(PWM_FREQUENCY+1));
		PWM_T3_ON;
		}
	break;
						
	case BEEP_ON:
	if (Beep_Timer == 0)	
		{
		Beep_Timer = 100;
		BeepState = BEEP_OFF;
		MTC_Stop_Charge_Discharge();
		SetBit(MCRA,3); // current mode
		Set_Duty_for_Current_Ref(0);  // 
		Set_Duty_for_Voltage_Mode(0);
		ALL_PWM_OFF;
		Beep_Number++;
		}
	break;
	}
}


void Led(void)
{
switch (State)
			{
			default:
			case MENU_0:
			case MENU_1:
			case MENU_2:
			case MENU_CALIB_1:
			case MENU_CALIB_2:
				LED_ON_Time = 0;
				break;
			
			case TIMEOUT:
			case OVERTEMP:
			case CHECK_BATTERY_CONNECTED:
				if (LED_Display_Timer == 0)
					{
					LED_Display_Timer = 2;  // 20 ms
					if (LED_ON_Time != 0)	LED_ON_Time--;
					else LED_ON_Time = 10; 
					}
				break;

				case WAIT_FOR_CHARGE:
					LED_ON_Time = 1; // LED on
					break;
					
			case DISCHARGE_1:
			case DISCHARGE_2:
				if (LED_Display_Timer == 0)
					{
					LED_Display_Timer = 10;  // 100 ms
					if (LED_ON_Time != 0)	LED_ON_Time--;
					else LED_ON_Time = 10; 
					}
				break;
				
			case CHARGE_NIMH:
			case CHARGE_LIPO_PHASE_1:
			case CHARGE_LIPO_PHASE_2:
				if (LED_Display_Timer == 0)
					{
					if (LED_ON_Time < 10)	LED_ON_Time++;
					else LED_ON_Time = 0; 
					/*if (LED_ON_Time < 5)	LED_Display_Timer = 20;  // 200ms
					else*/ LED_Display_Timer = 10; // 100 ms
					}
				break;
				
			case END_CHARGE:
			case END_DISCHARGE:
			case CHARGE_INTERRUPTED:
				LED_ON_Time = 10; // LED on
				break;
			}
}

void toggle_PA1(void)
{
if (PADR & 0x02) PADR &= (u8)(~0x02);
else	PADR |= 0x02;
}

/*** (c) 2006 ****************** END OF FILE ***/


