/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  opamp.c
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Operational Amplifier Control Routines
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. THE AUTHOR 
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  

#include "lib.h"
#include "ST7MC_hr.h"
#include "opamp.h"
#include "misc.h"


void OPAMP_InitOffset(u8 Gain)
{   
	OACSR |= OAON;	// Power-up the Op-Amp 
    Wait1ms();    // Wait for OPAMP to wake up
	
	OACSR |= OAON + OFFCMP + AVGCMP;
	while(!(OACSR & CMPOVR));		// Wait compensation completion

	if	(Gain == LOW_GAIN)	OACSR &= ((u8) ~HIGHGAIN);		// Close Loop Gain up to 20dB
	else	OACSR |= HIGHGAIN;				// Close Loop Gain More than 20dB

}	

    

/*** (c) 2006 ****************** END OF FILE ***/
