/**************** (c) 2006 Florent COSTE **********************

PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  Mtc_hr.h
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :  MTC hardware register prototypes
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

******************************************************************************/

#ifndef MTC_HR_H
#define MTC_HR_H


/* ----------------- Motor Control peripheral dedicated macros ------------- */
#define SET_MTC_PAGE(x) AffBit(MCFR,7,x)	/* Set active page of MTC peripheral */
#define ToCMPxH(CMP,Value)         ( CMP = (u8)(Value >> 5 ) )
#define ToCMPxL(CMP,Value)         ( CMP = (u8)(Value << 3 ) )


/*---REGISTERS---*/ 
                                           
#ifdef __HIWARE__						/* For METROWERKS / HIWARE Compiler*/
/* Registers in page 0 */
extern volatile u8 MTIM;	/* MTC Timer Counter High Register */
extern volatile u8 MTIML;	/* MTC Timer Counter Low Register */
extern volatile u8 MZPRV;	/* MTC Zn-1 Capture Register */ 
extern volatile u8 MZREG;	/* MTC Zn Capture Register */
extern volatile u8 MCOMP;	/* MTC Cn-1 Compare Register */
extern volatile u8 MDREG;	/* MTC D Capture/Compare Register */
extern volatile u8 MWGHT;	/* MTC Weight Register */
extern volatile u8 MPRSR;	/* MTC Prescaler and Ratio Register */ 
extern volatile u8 MIMR;	/* MTC Interrupt Mask Register */
extern volatile u8 MISR;	/* MTC Interrupt Status Register */
extern volatile u8 MCRA;	/* MTC Control Register A */
extern volatile u8 MCRB;	/* MTC Control Register B */
extern volatile u8 MCRC;	/* MTC Control Register C */
extern volatile u8 MPHST;	/* MTC Phase State Register */
extern volatile u8 MDFR;	/* MTC D event Filter Register */
extern volatile u8 MCFR;	/* MTC Current feedback Filter register */
extern volatile u8 MREF;	/* MTC Reference Register */
extern volatile u8 MPCR;	/* MTC PWM Control Register */
extern volatile u8 MREP;	/* MTC Repetition Counter Register */
extern volatile u8 MCPWH;	/* MTC Compare Phase W Preload register High */
extern volatile u8 MCPWL;	/* MTC Compare Phase W Preload register Low */
extern volatile u8 MCPVH;	/* MTC Compare Phase V Preload register High */
extern volatile u8 MCPVL;	/* MTC Compare Phase V Preload register Low */
extern volatile u8 MCPUH;	/* MTC Compare Phase U Preload register High */
extern volatile u8 MCPUL;	/* MTC Compare Phase U Preload register Low */
extern volatile u8 MCP0H;	/* MTC Compare Phase 0 Preload register High */
extern volatile u8 MCP0L;	/* MTC Compare Phase 0 Preload register Low */

/* Registers in page 1 */
extern volatile u8 MDTG;	/* MTC Dead Time generator register */
extern volatile u8 MPOL;	/* MTC Output Polarity Register */ 
extern volatile u8 MPWME;	/* MTC PWM Register */
extern volatile u8 MCONF;	/* MTC Configuration Register */
extern volatile u8 MPAR;	/* MTC Output Parity Register */
extern volatile u8 MZFR;	/* MTC Z event Filter Register */
extern volatile u8 MSCR;	/* MTC Sampling Clock Register */


#else
#ifdef __CSMC__							/* only for Cosmic Compiler*/
/* Registers in page 0 */
@tiny extern volatile u8 MTIM @0x50;	/* MTC Timer Counter High Register */
@tiny extern volatile u8 MTIML @0x51;	/* MTC Timer Counter Low Register */
@tiny extern volatile u8 MZPRV @0x52;	/* MTC Zn-1 Capture Register */ 
@tiny extern volatile u8 MZREG @0x53;	/* MTC Zn Capture Register */
@tiny extern volatile u8 MCOMP @0x54;	/* MTC Cn-1 Compare Register */
@tiny extern volatile u8 MDREG @0x55;	/* MTC D Capture/Compare Register */
@tiny extern volatile u8 MWGHT @0x56;	/* MTC Weight Register */
@tiny extern volatile u8 MPRSR @0x57;	/* MTC Prescaler and Ratio Register */ 
@tiny extern volatile u8 MIMR @0x58;	/* MTC Interrupt Mask Register */
@tiny extern volatile u8 MISR @0x59;	/* MTC Interrupt Status Register */
@tiny extern volatile u8 MCRA @0x5A;	/* MTC Control Register A */
@tiny extern volatile u8 MCRB @0x5B;	/* MTC Control Register B */
@tiny extern volatile u8 MCRC @0x5C;	/* MTC Control Register C */
@tiny extern volatile u8 MPHST @0x5D;	/* MTC Phase State Register */
@tiny extern volatile u8 MDFR @0x5E;	/* MTC D event Filter Register */
@tiny extern volatile u8 MCFR @0x5F;	/* MTC Current feedback Filter register */
@tiny extern volatile u8 MREF @0x60;	/* MTC Reference Register */
@tiny extern volatile u8 MPCR @0x61;	/* MTC PWM Control Register */
@tiny extern volatile u8 MREP @0x62;	/* MTC Repetition Counter Register */
@tiny extern volatile u8 MCPWH @0x63;	/* MTC Compare Phase W Preload register High */
@tiny extern volatile u8 MCPWL @0x64;	/* MTC Compare Phase W Preload register Low */
@tiny extern volatile u8 MCPVH @0x65;	/* MTC Compare Phase V Preload register High */
@tiny extern volatile u8 MCPVL @0x66;	/* MTC Compare Phase V Preload register Low */
@tiny extern volatile u8 MCPUH @0x67;	/* MTC Compare Phase U Preload register High */
@tiny extern volatile u8 MCPUL @0x68;	/* MTC Compare Phase U Preload register Low */
@tiny extern volatile u8 MCP0H @0x69;	/* MTC Compare Phase 0 Preload register High */
@tiny extern volatile u8 MCP0L @0x6A;	/* MTC Compare Phase 0 Preload register Low */

/* Registers in Page 1 */
@tiny extern volatile u8 MDTG @0x50;	/* MTC Dead Time generator register */
@tiny extern volatile u8 MPOL @0x51;	/* MTC Output Polarity Register */ 
@tiny extern volatile u8 MPWME @0x52;	/* MTC PWM Register */
@tiny extern volatile u8 MCONF @0x53;	/* MTC Configuration Register */
@tiny extern volatile u8 MPAR @0x54;	/* MTC Output Parity Register */
@tiny extern volatile u8 MZFR @0x55;	/* MTC Z event Filter Register */
@tiny extern volatile u8 MSCR @0x56;	/* MTC Sampling Clock Register */

#else
  #error"Unsupported Compiler!"	// Compiler Defines not found! 
#endif
#endif

/*---CONSTANTS---*/

/* MCRA: MTC Control Register A bit definition */

#define MOE		((u8)0x07)     	/* Output Enable */
#define CKE	    ((u8)0x06)		/* Clock enable	*/
#define SR		((u8)0x05)     	/* Sensor ON/OFF */
#define DAC		((u8)0x04)     	/* Direct Access */
#define VOC1	((u8)0x03)		/* Voltage/Current mode */
#define SWA		((u8)0x02)     	/* Switched/autoswitched mode */
#define PZ		((u8)0x01)		/* Z protection	*/
#define DCB		((u8)0x00)     	/* Data Capture bit */

#define MOE_MSK		((u8)0x80)     	/* Output Enable mask */
#define CKE_MSK	    ((u8)0x40)		/* Clock enable mask */
#define SR_MSK		((u8)0x20)     	/* Sensor ON/OFF mask */
#define DAC_MSK		((u8)0x10)     	/* Direct Access mask */
#define VOC1_MSK	((u8)0x08)		/* Voltage/Current mode mask */
#define CUR_MODE ((u8)0x08)		/* Idem previous line, but more explicit */
#define SWA_MSK		((u8)0x04)     	/* Switched/autoswitched mode mask */
#define PZ_MSK		((u8)0x02)		/* Z protection mask */
#define DCB_MSK		((u8)0x01)     	/* Data Capture bit mask */
   
   
/* MCRB: MTC Control Register B bit definition */

#define CPB		((u8)0x06)		/* Z compare bit preload */
#define HDM		((u8)0x05)     	/* Hardware D event preload */  
#define SDM		((u8)0x04)     	/* Software D event preload */
#define OCV		((u8)0x03)     	/* over current protection  */


#define CPB_MSK	((u8)0x40)		/* Z compare bit preload mask */
#define ZC_RISE	((u8)0x40)		/* Z compare bit preload mask */
#define ZC_FALL	((u8)0x00)		/* Z compare bit preload mask */
#define HDM_MSK	((u8)0x20)     	/* Hardware D event preload mask */  
#define SDM_MSK	((u8)0x10)     	/* Software D event preload mask */
#define OCV_MSK	((u8)0x08)     	/* Over current protection mask */
#define OS2_MSK	((u8)0x04)	/* operating mode selection */

#define Preload_mask	((u8) CPB_MSK | HDM_MSK | SDM_MSK | OS2_MSK)	/*Mask of Preload bit */



/* MCRC: MTC Control Register C bit definition */

#define SEI		((u8)0x07)		/* Speed error interrupt flag */
#define OI		((u8)0x07)		/* MTIM overflow flag */
#define EDIR	((u8)0x06)     	/* Encoder direction */
#define HZ		((u8)0x06)		/* Hardware Z event */
#define SZ		((u8)0x05)		/* Software Z event */
#define SC		((u8)0x04)		/* Software C event */
#define SPLG	((u8)0x03)		/* Sampling 1MHz */

#define SEI_MSK	((u8)0x80)		/* Speed error interrupt flag mask */
#define OI_MSK	((u8)0x80)		/* MTIM overflow flag mask */
#define EDIR_MSK ((u8)0x40)     /* Encoder direction mask */
#define HZ_MSK	((u8)0x40)		/* Hardware Z event mask */
#define SZ_MSK	((u8)0x20)		/* Software Z event mask */
#define SC_MSK	((u8)0x10)		/* Software C event mask */
#define SPLG_MSK ((u8)0x08)		/* Sampling 1MHz mask */


#define VREF_EXT	((u8)7)		/* Threshold voltage set by external MCVREF pin */
#define VREF_3V5	((u8)6)		/* 3.5V internal threshold voltage */
#define VREF_2V5	((u8)5)		/* 2.5V internal threshold voltage */
#define VREF_2V		((u8)4)		/* 2V internal threshold voltage */
#define VREF_1V5	((u8)3)		/* 1.5V internal threshold voltage */
#define VREF_1V		((u8)2)		/* 1V internal threshold voltage */
#define VREF_0V6	((u8)1)		/* 0.6V internal threshold voltage */
#define VREF_0V2	((u8)0)		/* 0.2V internal threshold voltage */


/* MPHST: MTC Phase State register bit definition */

#define MCO0		((u8)0x01)     	/* MCO0 Channel ON */
#define MCO1		((u8)0x02)     	/* MCO1 Channel ON */
#define MCO2		((u8)0x04)     	/* MCO2 Channel ON */
#define MCO3		((u8)0x08)     	/* MCO3 Channel ON */
#define MCO4		((u8)0x10)     	/* MCO4 Channel ON */
#define MCO5		((u8)0x20)     	/* MCO5 Channel ON */

#define MCIA		((u8)0x00)     	/* MCIA Input selected */
#define MCIB		((u8)0x40)     	/* MCIB Input selected */
#define MCIC		((u8)0x80)     	/* MCIC Input selected */
#define ENCODER		((u8)0xC0)     	/* Encoder mode selection mask */


/* MISR: MTC Interrupt status Register bit definition */

#define PUI		((u8)0x07)     	/* PWM Update Interrupt flag */
#define RPI	    ((u8)0x06)		/* Ratio Increment interrupt flag */
#define RMI		((u8)0x05)     	/* Ratio Decrement interrupt flag */
#define CLI		((u8)0x04)     	/* Current Limitation interrupt flag */
#define EI		((u8)0x03)		/* Emergency stop Interrupt flag */
#define ZI		((u8)0x02)     	/* BEMF Zero-crossing interrupt flag */
#define DI		((u8)0x01)		/* End of Demagnetization interrupt flag */
#define CI		((u8)0x00)     	/* Commutation / Capture interrupt flag */

#define PUI_MSK		((u8)0x80) 	/* PWM Update Interrupt flag */
#define RPI_MSK	    ((u8)0x40)	/* Ratio Increment interrupt flag */
#define RMI_MSK		((u8)0x20) 	/* Ratio Decrement interrupt flag */
#define CLI_MSK		((u8)0x10) 	/* Current Limitation interrupt flag */
#define EI_MSK		((u8)0x08)	/* Emergency stop Interrupt flag */
#define ZI_MSK		((u8)0x04)  /* BEMF Zero-crossing interrupt flag */
#define DI_MSK		((u8)0x02)	/* End of Demagnetization interrupt flag */
#define CI_MSK		((u8)0x01)  /* Commutation / Capture interrupt flag */


/* MPRSR: MTC Prescaler and Sampling Register Masks definition */
//#define SAMPLING_RATE	SMPL_18K1	

#define SMPL_50K		((u8)0x00) 	/* Sampling frequency in current Mode */
#define SMPL_40K		((u8)0x10) 	/* Sampling frequency in current Mode */
#define SMPL_33K3		((u8)0x20) 	/* Sampling frequency in current Mode */
#define SMPL_25K		((u8)0x30) 	/* Sampling frequency in current Mode */
#define SMPL_20K		((u8)0x40) 	/* Sampling frequency in current Mode */
#define SMPL_18K1		((u8)0x50) 	/* Sampling frequency in current Mode */
#define SMPL_15K4		((u8)0x60) 	/* Sampling frequency in current Mode */
#define SMPL_12K5		((u8)0x70) 	/* Sampling frequency in current Mode */
#define SMPL_10K		((u8)0x80) 	/* Sampling frequency in current Mode */
#define SMPL_6K25		((u8)0x90) 	/* Sampling frequency in current Mode */
#define SMPL_3K13		((u8)0xA0) 	/* Sampling frequency in current Mode */
#define SMPL_1K56		((u8)0xB0) 	/* Sampling frequency in current Mode */
#define SMPL_1K25		((u8)0xC0) 	/* Sampling frequency in current Mode */
#define SMPL_961		((u8)0xD0) 	/* Sampling frequency in current Mode */
#define SMPL_625		((u8)0xD0) 	/* Sampling frequency in current Mode */
#define SMPL_390		((u8)0xF0) 	/* Sampling frequency in current Mode */


/* MIMR: MTC Interrupt Mask Register bit definition */

#define PUM    ((u8)0x07)     	/* PWM Update enable bit position */
#define SEM    ((u8)0x06) 	/* Speed Error enable bit position */
#define RIM    ((u8)0x05)  	/* Ratio update Interrupt enable bit position */
#define CLIM   ((u8)0x04)     	/* Current Limitation Interrupt enable bit position */
#define EIM    ((u8)0x03)     	/* Emergency stop Interrupt enable bit position */
#define ZIM    ((u8)0x02)     	/* Back EMF Zero-crossing Interrupt enable bit position */
#define DIM    ((u8)0x01)     	/* End of Demagnetization Interrupt enable bit position */
#define CIM    ((u8)0x00)     	/* Commutation / Capture Interrupt enable bit position */

#define PUM_MSK	((u8)0x80)     	/* PWM Update enable Mask */
#define SEM_MSK	((u8)0x40) 	   	/* Speed Error enable bit Mask*/
#define RIM_MSK	((u8)0x20)      /* Ratio update Interrupt enable Mask */
#define CLIM_MSK ((u8)0x10)		/* Current Limitation Interrupt enable Mask */
#define EIM_MSK	((u8)0x08)     	/* Emergency stop Interrupt enable Mask */
#define ZIM_MSK	((u8)0x04)     	/* Back EMF Zero-crossing Interrupt enable Mask */
#define DIM_MSK	((u8)0x02)     	/* End of Demagnetization Interrupt enable Mask */
#define CIM_MSK	((u8)0x01)     	/* Commutation / Capture Interrupt enable Mask */


/* MPAR: MTC Parity Register */
#define TACHO_RISING	((u8)0x40)	/* Speed Sensor, Rising edge sensitive */
#define TACHO_FALLING	((u8)0x80)	/* Speed Sensor, Falling edge sensitive */
#define TACHO_BOTH_EDGE	((u8)0xC0)	/* Speed Sensor, both edge sensitive */


/* MPOL: MTC Polarity Register bit definition */

#define ZVD		((u8)0x07)		/* Z vs D edge polarity */
#define REO		((u8)0x06)		/* Read on Even or Odd channel */
#define POL_MSK	((u8)0x3F)		/* Polarity bit selection mask */
#define ALL_ACTIVE_HIGH	((u8)0x3F)	/* All switch drivers having positive logic inputs */


/* MDFR: MTC D Event Filter Register */
#define D_EVT_SAMPLE_16	((u8)0xf0)		/* active event after 16 consecutive D valid samples */
#define D_EVT_SAMPLE_15	((u8)0xe0)		/* active event after 15 consecutive D valid samples */
#define D_EVT_SAMPLE_14	((u8)0xd0)		/* active event after 14 consecutive D valid samples */
#define D_EVT_SAMPLE_13	((u8)0xc0)		/* active event after 13 consecutive D valid samples */
#define D_EVT_SAMPLE_12	((u8)0xb0)		/* active event after 12 consecutive D valid samples */
#define D_EVT_SAMPLE_11	((u8)0xa0)		/* active event after 11 consecutive D valid samples */
#define D_EVT_SAMPLE_10	((u8)0x90)		/* active event after 10 consecutive D valid samples */
#define D_EVT_SAMPLE_9	((u8)0x80)		/* active event after 9 consecutive D valid samples */
#define D_EVT_SAMPLE_8	((u8)0x70)		/* active event after 8 consecutive D valid samples */
#define D_EVT_SAMPLE_7	((u8)0x60)		/* active event after 7 consecutive D valid samples */
#define D_EVT_SAMPLE_6	((u8)0x50)		/* active event after 6 consecutive D valid samples */
#define D_EVT_SAMPLE_5	((u8)0x40)		/* active event after 5 consecutive D valid samples */
#define D_EVT_SAMPLE_4	((u8)0x30)		/* active event after 4 consecutive D valid samples */
#define D_EVT_SAMPLE_3	((u8)0x20)		/* active event after 3 consecutive D valid samples */
#define D_EVT_SAMPLE_2	((u8)0x10)		/* active event after 2 consecutive D valid samples */
#define D_EVT_SAMPLE_1	((u8)0x00)		/* active event after 1 consecutive D valid samples */

#define D_EVENT_FILT_200us	((u8)0x0f)		/* 200us filter between events */
#define D_EVENT_FILT_180us	((u8)0x0e)		/* 180us filter between events */
#define D_EVENT_FILT_160us	((u8)0x0d)		/* 160us filter between events */
#define D_EVENT_FILT_140us	((u8)0x0c)		/* 140us filter between events */
#define D_EVENT_FILT_120us	((u8)0x0b)		/* 120us filter between events */
#define D_EVENT_FILT_100us	((u8)0x0a)		/* 100us filter between events */
#define D_EVENT_FILT_80us	((u8)0x09)		/* 80us filter between events */
#define D_EVENT_FILT_60us	((u8)0x08)		/* 60us filter between events */
#define D_EVENT_FILT_40us	((u8)0x07)		/* 40us filter between events */
#define D_EVENT_FILT_35us	((u8)0x06)		/* 35us filter between events */
#define D_EVENT_FILT_30us	((u8)0x05)		/* 30us filter between events */
#define D_EVENT_FILT_25us	((u8)0x04)		/* 25us filter between events */
#define D_EVENT_FILT_20us	((u8)0x03)		/* 20us filter between events */
#define D_EVENT_FILT_15us	((u8)0x02)		/* 15us filter between events */
#define D_EVENT_FILT_10us	((u8)0x01)		/* 10us filter between events */
#define D_EVENT_FILT_5us	((u8)0x00)		/* 5us filter between events */


/* MZFR: MTC Current feedback Filter Register */
#define Z_EVT_SAMPLE_16	((u8)0xf0)		/* active event after 16 consecutive D valid samples */
#define Z_EVT_SAMPLE_15	((u8)0xe0)		/* active event after 15 consecutive D valid samples */
#define Z_EVT_SAMPLE_14	((u8)0xd0)		/* active event after 14 consecutive D valid samples */
#define Z_EVT_SAMPLE_13	((u8)0xc0)		/* active event after 13 consecutive D valid samples */
#define Z_EVT_SAMPLE_12	((u8)0xb0)		/* active event after 12 consecutive D valid samples */
#define Z_EVT_SAMPLE_11	((u8)0xa0)		/* active event after 11 consecutive D valid samples */
#define Z_EVT_SAMPLE_10	((u8)0x90)		/* active event after 10 consecutive D valid samples */
#define Z_EVT_SAMPLE_9	((u8)0x80)		/* active event after 9 consecutive D valid samples */
#define Z_EVT_SAMPLE_8	((u8)0x70)		/* active event after 8 consecutive D valid samples */
#define Z_EVT_SAMPLE_7	((u8)0x60)		/* active event after 7 consecutive D valid samples */
#define Z_EVT_SAMPLE_6	((u8)0x50)		/* active event after 6 consecutive D valid samples */
#define Z_EVT_SAMPLE_5	((u8)0x40)		/* active event after 5 consecutive D valid samples */
#define Z_EVT_SAMPLE_4	((u8)0x30)		/* active event after 4 consecutive D valid samples */
#define Z_EVT_SAMPLE_3	((u8)0x20)		/* active event after 3 consecutive D valid samples */
#define Z_EVT_SAMPLE_2	((u8)0x10)		/* active event after 2 consecutive D valid samples */
#define Z_EVT_SAMPLE_1	((u8)0x00)		/* active event after 1 consecutive D valid samples */

#define Z_EVENT_FILT_200us	((u8)0x0f)		/* 200us filter between events */
#define Z_EVENT_FILT_180us	((u8)0x0e)		/* 180us filter between events */
#define Z_EVENT_FILT_160us	((u8)0x0d)		/* 160us filter between events */
#define Z_EVENT_FILT_140us	((u8)0x0c)		/* 140us filter between events */
#define Z_EVENT_FILT_120us	((u8)0x0b)		/* 120us filter between events */
#define Z_EVENT_FILT_100us	((u8)0x0a)		/* 100us filter between events */
#define Z_EVENT_FILT_80us	((u8)0x09)		/* 80us filter between events */
#define Z_EVENT_FILT_60us	((u8)0x08)		/* 60us filter between events */
#define Z_EVENT_FILT_40us	((u8)0x07)		/* 40us filter between events */
#define Z_EVENT_FILT_35us	((u8)0x06)		/* 35us filter between events */
#define Z_EVENT_FILT_30us	((u8)0x05)		/* 30us filter between events */
#define Z_EVENT_FILT_25us	((u8)0x04)		/* 25us filter between events */
#define Z_EVENT_FILT_20us	((u8)0x03)		/* 20us filter between events */
#define Z_EVENT_FILT_15us	((u8)0x02)		/* 15us filter between events */
#define Z_EVENT_FILT_10us	((u8)0x01)		/* 10us filter between events */
#define Z_EVENT_FILT_5us	((u8)0x00)		/* 5us filter between events */


/* MCFR: MTC Current feedback Filter Register */
#define RPGS	((u8)0x07)		/* Register page selection */
#define RST		((u8)0x06)     	/* Reset MTC peripheral */

#define CURRENT_FD_SAMPLE_8	((u8)0x38)		/* active event after 8 consecutive valid samples */
#define CURRENT_FD_SAMPLE_7	((u8)0x30)		/* active event after 7 consecutive valid samples */
#define CURRENT_FD_SAMPLE_6	((u8)0x28)		/* active event after 6 consecutive valid samples */
#define CURRENT_FD_SAMPLE_5	((u8)0x20)		/* active event after 5 consecutive valid samples */
#define CURRENT_FD_SAMPLE_4	((u8)0x18)		/* active event after 4 consecutive valid samples */
#define CURRENT_FD_SAMPLE_3	((u8)0x10)		/* active event after 3 consecutive valid samples */
#define CURRENT_FD_SAMPLE_2	((u8)0x08)		/* active event after 2 consecutive valid samples */
#define CURRENT_FD_SAMPLE_1	((u8)0x00)		/* active event after 1 consecutive valid sample  */

#define CURRENT_FILT_3us5	((u8)0x07)		/* 3.5us Current filter */
#define CURRENT_FILT_3us	((u8)0x06)		/* 3us   Current filter */
#define CURRENT_FILT_2us5	((u8)0x05)		/* 2.5us Current filter */
#define CURRENT_FILT_2us	((u8)0x04)		/* 2us   Current filter */
#define CURRENT_FILT_1us5	((u8)0x03)		/* 1.5us Current filter */
#define CURRENT_FILT_1us	((u8)0x02)		/* 1us   Current filter */
#define CURRENT_FILT_0us5	((u8)0x01)		/* 0.5us Current filter */
#define CURRENT_FILT_OFF	((u8)0x00)		/* Current filter OFF */


/* MSCR: MTC Sampling Clock Register */
#define ZSV		((u8)0x07)		/* Z event sampling validation */
#define ECM		((u8)0x01)		/* Encoder Capture Mode */
#define DISS	((u8)0x00)		/* Data Input Selection */

#define SAMPLING_CLK_1MHZ	((u8)0x00)		/* 1 Mhz sampling clock frequency */
#define SAMPLING_CLK_500KHZ	((u8)0x04)		/* 500 Khz sampling clock frequency */
#define SAMPLING_CLK_250KHZ	((u8)0x08)		/* 250 Khz sampling clock frequency */
#define SAMPLING_CLK_125KHZ	((u8)0x0c)		/* 125 Khz sampling clock frequency */


/* MREF: MTC Reference Register bit definition */

#define HST		((u8)0x07)		/* Hysteresis comparator value */
#define CL		((u8)0x06)		/* Current loop comparator value */
#define CFAV	((u8)0x05)		/* Current Feedback Amplifier entry Validation */
#define HFE1	((u8)0x04)		/* Chopping mode direction selection */
#define HFE0	((u8)0x03)		/* Chopping mode direction selection */
#define HFRQ2	((u8)0x02)		/* Chopping frequency selection */
#define HFRQ1	((u8)0x01)		/* Chopping frequency selection */
#define HFRQ0	((u8)0x00)		/* Chopping frequency selection */

#define HFEMASK	((u8)0x18)		/* Chopping mode direction selection mask */
#define HFRMASK ((u8)0x07)		/* Chopping frequency selection mask */

#define HST_MASK	((u8)0x80)		/* Hysteresis   comparator value */
#define CL_MASK		((u8)0x40)		/* Current loop comparator value */
#define CFAV_MASK	((u8)0x20)		/* Current Feedback Amplifier entry Validation */

/* MDTG: MTC Dead Time Generator Register bit definition*/

#define PCN		((u8)0x07)		/* PWM Channel number/motor select */ 
#define DTE		((u8)0x06)		/* Dead Time Generator Enable */


/* MPWME: MTC PWM Enable Register bit definition*/

#define DG		((u8)0x07)		/* Debug option	*/ 
#define MPWMW	((u8)0x06)		/* PWM W output control bit */
#define MPWMV	((u8)0x05)		/* PWM W output control bit */
#define MPWMU	((u8)0x04)		/* PWM W output control bit */

#define DG_MSK		((u8)0x80)		/* Debug option	Mask */ 
#define MPWMW_MSK	((u8)0x40)		/* PWM W output control bit Mask */
#define MPWMV_MSK	((u8)0x20)		/* PWM W output control bit Mask */
#define MPWMU_MSK	((u8)0x10)		/* PWM W output control bit Mask */

#define T_OFF_2us5		((u8)0x00)	/* 2.5us Min Off Time in current mode */
#define T_OFF_5us		((u8)0x01)	/* 5us Min Off Time in current mode */
#define T_OFF_7us5		((u8)0x02)	/* 7.5us Min Off Time in current mode */
#define T_OFF_10us		((u8)0x03)	/* 10us Min Off Time in current mode */
#define T_OFF_12us5		((u8)0x04)	/* 12.5us Min Off Time in current mode */
#define T_OFF_15us		((u8)0x05)	/* 15us Min Off Time in current mode */
#define T_OFF_17us5		((u8)0x06)	/* 17.5us Min Off Time in current mode */
#define T_OFF_20us		((u8)0x07)	/* 20us Min Off Time in current mode */
#define T_OFF_22us5		((u8)0x08)	/* 22.5us Min Off Time in current mode */
#define T_OFF_25us		((u8)0x09)	/* 25us Min Off Time in current mode */
#define T_OFF_27us5		((u8)0x0A)	/* 27.5us Min Off Time in current mode */
#define T_OFF_30us		((u8)0x0B)	/* 30us Min Off Time in current mode */
#define T_OFF_32us5		((u8)0x0C)	/* 32.5us Min Off Time in current mode */
#define T_OFF_35us		((u8)0x0D)	/* 35us Min Off Time in current mode */
#define T_OFF_37us5		((u8)0x0E)	/* 37.5us Min Off Time in current mode */
#define T_OFF_40us		((u8)0x0F)	/* 40us Min Off Time in current mode */

/* MPCR: MTC PWM Control Register bit definition*/
#define PMS		((u8)0x07)		/* PWM Mode selection */
#define OVFU	((u8)0x06)		/* Phase U 100% duty cycle */
#define OVFV	((u8)0x05)		/* Phase U 100% duty cycle */
#define OVFW	((u8)0x04)		/* Phase U 100% duty cycle */
#define CMS		((u8)0x03)		/* PWM Counter Mode Selection */
#define PCP2	((u8)0x02)		/* Bit 2 of PWM Counter prescaler */
#define PCP1	((u8)0x01)		/* Bit 1 of PWM Counter prescaler */
#define PCP0	((u8)0x00)		/* Bit 0 of PWM Counter prescaler */

#define PMS_MSK		((u8)0x80)		/* PWM Mode selection mask */
#define CMS_MSK		((u8)0x08)		/* PWM Counter Mode Selection mask */
#define PCP2_MSK	((u8)0x04)		/* Bit 2 of PWM Counter prescaler */
#define PCP1_MSK	((u8)0x02)		/* Bit 1 of PWM Counter prescaler */
#define PCP0_MSK	((u8)0x01)		/* Bit 0 of PWM Counter prescaler */
#define PCPMASK		((u8)0x07)		/* PCP[2:0] bits mask */


/* MCONF: MTC Configuration Register bit definition*/  
#define SOI	    ((u8)0x03)		/*Sampling Out IT flag */
#define SOM	    ((u8)0x02)		/*Sampling Out IT mask bit */
#define XT16	((u8)0x01)		/*Peripheral frequency is Fmtc/4 */ 
#define XT8	    ((u8)0x00)		/*Peripheral frequency	is Fmtc/2 if this bit is set */

#define SOI_MSK	    ((u8)0x08)	/*Sampling Out IT flag mask */
#define SOM_MSK	    ((u8)0x04)	/*Sampling Out IT enable bit mask */
#define XT16_MSK	((u8)0x02)	/* Fmtc/4 enable mask*/
#define XT8_MSK		((u8)0x01)	/* Fmtc/2 enable mask*/

#endif


/**************** (c) 2006 Florent COSTE **********************/

