/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  mtc_hr.c
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : MTC hardware register definitions
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. THE AUTHOR 
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  

#include "lib.h"

/*---REGISTERS---*/ 
                                           
#ifdef __HIWARE__						/* For METROWERKS / HIWARE Compiler*/
/* Registers in page 0 */
volatile u8 MTIM @0x50;	/* MTC Timer Counter High Register */
volatile u8 MTIML @0x51;	/* MTC Timer Counter Low Register */
volatile u8 MZPRV @0x52;	/* MTC Zn-1 Capture Register */ 
volatile u8 MZREG @0x53;	/* MTC Zn Capture Register */
volatile u8 MCOMP @0x54;	/* MTC Cn-1 Compare Register */
volatile u8 MDREG @0x55;	/* MTC D Capture/Compare Register */
volatile u8 MWGHT @0x56;	/* MTC Weight Register */
volatile u8 MPRSR @0x57;	/* MTC Prescaler and Ratio Register */ 
volatile u8 MIMR @0x58;	/* MTC Interrupt Mask Register */
volatile u8 MISR @0x59;	/* MTC Interrupt Status Register */
volatile u8 MCRA @0x5A;	/* MTC Control Register A */
volatile u8 MCRB @0x5B;	/* MTC Control Register B */
volatile u8 MCRC @0x5C;	/* MTC Control Register C */
volatile u8 MPHST @0x5D;	/* MTC Phase State Register */
volatile u8 MDFR @0x5E;	/* MTC D event Filter Register */
volatile u8 MCFR @0x5F;	/* MTC Current feedback Filter register */
volatile u8 MREF @0x60;	/* MTC Reference Register */
volatile u8 MPCR @0x61;	/* MTC PWM Control Register */
volatile u8 MREP @0x62;	/* MTC Repetition Counter Register */
volatile u8 MCPWH @0x63;	/* MTC Compare Phase W Preload register High */
volatile u8 MCPWL @0x64;	/* MTC Compare Phase W Preload register Low */
volatile u8 MCPVH @0x65;	/* MTC Compare Phase V Preload register High */
volatile u8 MCPVL @0x66;	/* MTC Compare Phase V Preload register Low */
volatile u8 MCPUH @0x67;	/* MTC Compare Phase U Preload register High */
volatile u8 MCPUL @0x68;	/* MTC Compare Phase U Preload register Low */
volatile u8 MCP0H @0x69;	/* MTC Compare Phase 0 Preload register High */
volatile u8 MCP0L @0x6A;	/* MTC Compare Phase 0 Preload register Low */


/* Registers in page 1 */
volatile u8 MDTG @0x50;	/* MTC Dead Time generator register */
volatile u8 MPOL @0x51;	/* MTC Output Polarity Register */ 
volatile u8 MPWME @0x52;	/* MTC PWM Register */
volatile u8 MCONF @0x53;	/* MTC Configuration Register */
volatile u8 MPAR @0x54;	/* MTC Output Parity Register */
volatile u8 MZFR @0x55;	/* MTC Z event Filter Register */
volatile u8 MSCR @0x56;	/* MTC Sampling Clock Register */

#else

#ifdef __CSMC__				/* only for Cosmic Compiler*/
/* Register in page 0 */
@tiny volatile u8 MTIM @0x50;	/* MTC Timer Counter High Register */
@tiny volatile u8 MTIML @0x51;	/* MTC Timer Counter Low Register */
@tiny volatile u8 MZPRV @0x52;	/* MTC Zn-1 Capture Register */ 
@tiny volatile u8 MZREG @0x53;	/* MTC Zn Capture Register */
@tiny volatile u8 MCOMP @0x54;	/* MTC Cn-1 Compare Register */
@tiny volatile u8 MDREG @0x55;	/* MTC D Capture/Compare Register */
@tiny volatile u8 MWGHT @0x56;	/* MTC Weight Register */
@tiny volatile u8 MPRSR @0x57;	/* MTC Prescaler and Ratio Register */ 
@tiny volatile u8 MIMR @0x58;	/* MTC Interrupt Mask Register */
@tiny volatile u8 MISR @0x59;	/* MTC Interrupt Status Register */
@tiny volatile u8 MCRA @0x5A;	/* MTC Control Register A */
@tiny volatile u8 MCRB @0x5B;	/* MTC Control Register B */
@tiny volatile u8 MCRC @0x5C;	/* MTC Control Register C */
@tiny volatile u8 MPHST @0x5D;	/* MTC Phase State Register */
@tiny volatile u8 MDFR @0x5E;	/* MTC D event Filter Register */
@tiny volatile u8 MCFR @0x5F;	/* MTC Current feedback Filter register */
@tiny volatile u8 MREF @0x60;	/* MTC Reference Register */
@tiny volatile u8 MPCR @0x61;	/* MTC PWM Control Register */
@tiny volatile u8 MREP @0x62;	/* MTC Repetition Counter Register */
@tiny volatile u8 MCPWH @0x63;	/* MTC Compare Phase W Preload register High */
@tiny volatile u8 MCPWL @0x64;	/* MTC Compare Phase W Preload register Low */
@tiny volatile u8 MCPVH @0x65;	/* MTC Compare Phase V Preload register High */
@tiny volatile u8 MCPVL @0x66;	/* MTC Compare Phase V Preload register Low */
@tiny volatile u8 MCPUH @0x67;	/* MTC Compare Phase U Preload register High */
@tiny volatile u8 MCPUL @0x68;	/* MTC Compare Phase U Preload register Low */
@tiny volatile u8 MCP0H @0x69;	/* MTC Compare Phase 0 Preload register High */
@tiny volatile u8 MCP0L @0x6A;	/* MTC Compare Phase 0 Preload register Low */

/*Register in Page 1 */
@tiny volatile u8 MDTG @0x50;	/* MTC Dead Time generator register */
@tiny volatile u8 MPOL @0x51;	/* MTC Output Polarity Register */ 
@tiny volatile u8 MPWME @0x52;	/* MTC PWM Register */
@tiny volatile u8 MCONF @0x53;	/* MTC Configuration Register */
@tiny volatile u8 MPAR @0x54;	/* MTC Output Parity Register */
@tiny volatile u8 MZFR @0x55;	/* MTC Z event Filter Register */
@tiny volatile u8 MSCR @0x56;	/* MTC Sampling Clock Register */

#else
  #error"Unsupported Compiler!"	// Compiler Defines not found! 
#endif

#endif

/*** (c) 2006 ****************** END OF FILE ***/

