/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  mtc.h
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :  MTC peripheral control routine prototypes 
              

******************************************************************************/  

#ifndef MTC_AC_H
#define MTC_AC_H  

/* Public Constants -------------------------------------------------------- */
#define PWM_FREQUENCY		((u16)(mem_MCPOH<<8) + mem_MCPOL)

#define T1	MCO0
#define T2	MCO1
#define T3	MCO2
#define T4	MCO3
#define T5	MCO4
#define T6	MCO5

#define ALL_PWM_OFF	{MPHST = (u8)0;}
#define PWM_T1_ON	{MCRB = 0x00;MPHST = (u8)T1;}
#define PWM_T2_ON	{MCRB = 0x07;MPHST = (u8)T2;}
#define PWM_T3_ON	{MCRB = 0x00;MPHST = (u8)T3;}


#define SAMPLING_TIME	5	// 10ms 
		                                                                



/* Public Variables -------------------------------------------------------- */   

                                 
extern u16 CurrentReference;

/* Public  macros ---------------------------------------------------------- */

/* Public Functions prototypes --------------------------------------------- */
void MTC_InitPeripheral(void);
void MTC_Charge(void);
void MTC_Discharge(void);
void MTC_Stop_Charge_Discharge(void);
void Set_Duty(u16);
void Set_Duty_for_Current_Ref(u16);
void Set_Duty_for_Voltage_Mode(u16);
	
#endif
/*** (c) 2006 ****************** END OF FILE ***/