/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  main.c
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main Routine
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. THE AUTHOR 
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  

#include "lib.h"
#include "mtc.h"
#include "i2c.h"  
#include "ST7MC_hr.h"
#include "ports.h"
#include "opamp.h"
#include "timer.h"
#include "it_ST7MC.h"  
#include "misc.h"
#include "wwdg.h" 
#include "regul.h"
#include "adc.h"
#include "MTC_Settings_Sensorless.h"
#include "lcd.h"  
#include "adc.h"  
#include "mtc_hr.h"  
                                          

static u16 duty, battery_voltage, current, previous_current_ref, previous_state;
static u16 Previous_Blinking_Flag_line1,Previous_Blinking_Flag_line2;

void main(void)
{                       
//	while ( !WWD_Init() ); 

  State = MENU_0;

	PORTS_Init();   // initialize I/O

	PWMART_Config();
 	TIMA_Config();  // initialize TIMER A peripheral
	TIMB_Config();  // initialize TIMER B peripheral
	
	Reset_Variables();  // reset software variables

	OPAMP_InitOffset(LOW_GAIN);
	//OPAMP_InitOffset(HIGH_GAIN);
	MTC_InitPeripheral();	// Initialize peripheral for Sensorless BLDC drive
  EnableInterrupts();
//	Wait(6); // 12 ms tempo
	Wait(25); // 50 ms tempo
	
	LCD_Init();	// init LCD

	I2C_EepromRead(0,4);  // adress 0x00, 4 bytes, check CRC
	if ( (I2c_EepBuff[0] != CRC1_Value) || (I2c_EepBuff[1] != CRC2_Value) )
//			|| (I2c_EepBuff[2] != CRC3_Value) || (I2c_EepBuff[3] != CRC4_Value) )   
		I2C_EepromLoad();  // write EEPROM if blank

	I2C_EepromRead(0,4);  // adress 0x00, 4 bytes, check CRC
	if ( (I2c_EepBuff[0] != CRC1_Value) || (I2c_EepBuff[1] != CRC2_Value) )
//			|| (I2c_EepBuff[2] != CRC3_Value) || (I2c_EepBuff[3] != CRC4_Value) )   
		while (1)	{
							LCD_No_EEPROM();		// re-check and display error message if EEPROM can't be detected
							Beep_LCD_Fault();		// and beep continuously
							}


	Beep_Init();
	LCD_Startup_Screen();		// welcome message

	I2C_EepromRead(EEPROM_MODEL_1_BASE_ADRESS + (Model_BYTE_SIZE*TOTAL_MODELS),3);  // read last model number used before shutdown
	if (I2c_EepBuff[2] > (TOTAL_MODELS-1))  // just in case...	
		{
		I2c_EepBuff[2] = 0;  // model 1 by default	
		I2Cm_Tx(I2C_EEP_ADR,(u8)((Model_BYTE_SIZE*TOTAL_MODELS) + EEPROM_MODEL_1_BASE_ADRESS),3);  // store datas		
		}

	DebounceButton = 0;		// entering calibration menu?
	key_scan();
	Key_Menu_Calibration();
	Key_Menu_Calibration();

if (State != MENU_CALIB_1)
	{
	Load_Model_Parameters(I2c_EepBuff[2]); // load model parameters
	Model_Display();  // refresh LCD buffers
	Blinking_Flag_line1 = 0xffff;
	Blinking_Flag_line2 = 0xffff;
	}


while(1)    // main loop
	{
	key_scan();  // scan key entries

	if (Display_Timer == 0)	// refresh LCD?
		{
//		Display_Timer = 125; // refresh LCD every 250 ms
//		Display_Timer = 150; // refresh LCD every 300 ms
		Blinking();  // prepare LCD buffer for display
//		Display_Timer = 150; // refresh LCD every 300 ms
		LCD_send_Buffer_LCD_to_display();
		}		

	Led();

if ( (Temperature_Protection() == TRUE)	&& (State != OVERTEMP) ) 
		{
		previous_state = State;
		State = OVERTEMP;
		Set_Duty_for_Current_Ref(0);   
		MTC_Stop_Charge_Discharge();
		SetBit(Flag_1,Freeze_RTC);
		Previous_Blinking_Flag_line1 = Blinking_Flag_line1;
		Previous_Blinking_Flag_line2 = Blinking_Flag_line2;
		}

	regul_Fan(Chk_Temperature());
	
	switch (State)
			{
			default:
			case MENU_0:			// model selection & parameters
				Key_Menu_0();
				Model_Display();  // refresh LCD buffers
				previous_state = MENU_0;
				break;

			case CHECK_BATTERY_CONNECTED:
				Key_Menu_Check_Battery_Connected();			
				if (Chk_Battery_connection() == TRUE)  // chk bat. connection
					{
					ClrBit(Flag_1,Freeze_RTC);
					Blinking_Flag_line1 = 0xffff;
					Blinking_Flag_line2 = 0xffff;
					
					if (previous_state == DISCHARGE_1)
						{
						Set_Duty_for_Current_Ref(0);  
						MTC_Discharge();
						Init_PI();  // reset integral term
						State = DISCHARGE_1;
						VCUTOFF_Timer = 100;  // 5 sec voltage underflow detection
						Load_Buffer_LCD(9,12);  // discharge
						RTC_Compute(12,RTC_hour,RTC_min,1);
						Blinking_Flag_line1 = 0x1f;  // 'discharge' blinking
						Blinking_Flag_line2 = 0xffff;  
						u16HexToDec_LCD(Get_Battery_Voltage(),0,0);
						u16HexToDec_LCD(capa,8,1); 
						ClrBit(Flag_1, Chk_Bat_Capacity);
						Timer_Bat_Capacity = 600;
						ClrBit(Flag_1,SAMP_EVT);
						}
					else if ( (previous_state == CHARGE_NIMH) || (previous_state == CHARGE_LIPO_PHASE_1) || (previous_state == CHARGE_LIPO_PHASE_2) )// battery disconnected during charging process
						{
						u8 i;
						
						Set_Duty_for_Current_Ref(0);  
						MTC_Charge();
						Init_PI();  // reset integral trerm

						Load_Buffer_LCD(10,11);  // charge line 1, line 2
						Blinking_Flag_line1 = 0x00ff;	// 'charging' blinking
						Blinking_Flag_line2 = 0xffff; 
						RTC_Compute(12,RTC_hour,RTC_min,1);  // line 1
						ClrBit(Flag_1, SAMP_EVT);
						ClrBit(Flag_1, Chk_Buffer);
						for (i=1;i<=4;i++)
							{
							Buffer[15+i]=Buffer[15];// clear last 4 values in case of wrong data stored					
							}
						
						battery_voltage = Get_Battery_Voltage();
						if (Model.LiPO == TRUE) State = CHARGE_LIPO_PHASE_1; // 2 LiPO cells??
						else State = CHARGE_NIMH;
						}
						else 
							{
							State = MENU_1; 
							Reset_RTC();
							}
					}				
				break;

			case MENU_1:		// prepare discharge
				Init_PI();  // reset integral term
				
				if (Model.I_Discharge_Start<=DISCHARGE_OFF)	State = MENU_2;// no discharge? -> goto menu 2
				else 
					{
					State = DISCHARGE_1;
					VCUTOFF_Timer = 100;  // 5 sec voltage underflow detection
					MTC_Discharge();
					
					Load_Buffer_LCD(9,12);  // discharge
					RTC_Compute(12,RTC_hour,RTC_min,1);
					Blinking_Flag_line1 = 0x1f;  // 'discharge' blinking
					Blinking_Flag_line2 = 0xffff;  // 'discharge' blinking
					u16HexToDec_LCD(Get_Battery_Voltage(),0,0);
					u16HexToDec_LCD(capa,8,1);   
					ClrBit(Flag_1, Chk_Bat_Capacity);
					Timer_Bat_Capacity = 600;
					ClrBit(Flag_1,SAMP_EVT);
					}
				break;

			case DISCHARGE_1:
				Key_Menu_Discharge();
				if (ValBit(Flag_1, Chk_Bat_Capacity))  // every 30 sec
					{
					ClrBit(Flag_1, Chk_Bat_Capacity);
					
					Load_Buffer_LCD(9,12);  // discharge
					RTC_Compute(12,RTC_hour,RTC_min,1);
					Blinking_Flag_line1 = 0x1f;  // 'discharge' blinking
					Blinking_Flag_line2 = 0xffff;  // 'discharge' blinking
					u16HexToDec_LCD(Get_Battery_Voltage(),0,0);
					capa = Get_Capacity();
					u16HexToDec_LCD(capa,8,1);
					}
				
				if (ValBit(Flag_1,SAMP_EVT))  // every 10 ms
					{
					u16 temp;
					
					ClrBit(Flag_1,SAMP_EVT);	
					
					Set_Duty_for_Current_Ref(regul_PI(Model.I_Discharge_Start,0));	
					
					Load_Buffer_LCD(9,12);  // discharge
					RTC_Compute(12,RTC_hour,RTC_min,1);
					Blinking_Flag_line1 = 0x1f;  // 'discharge' blinking
					temp = Get_Battery_Voltage();
					u16HexToDec_LCD(temp,0,0);
					u16HexToDec_LCD(capa,8,1);  // display capacity
					
//					if (temp >= (u16)(100*(Model.VCutoff+(u8)(Model.VCutoff/8))))	VCUTOFF_Timer = 20; // 1 sec voltage underflow detection Vbat = vcutoff + 12.5%
					if (temp >= (u16)( (100*Model.VCutoff) + (u16)(100*Model.VCutoff)/8))	VCUTOFF_Timer = 20; // 1 sec voltage underflow detection Vbat = vcutoff + 12.5%
					else if (VCUTOFF_Timer == 0)	
						{
						Init_PI();  // reset integral term
						VCUTOFF_Timer = 120;  // 6 sec
						State = DISCHARGE_2;
						break;
						}
					
		/*			if ( (Get_Current() < 50)	&& (MaxPiOut == TRUE) )// chk if battery still connected
						{
						Set_Duty_for_Current_Ref(0);  // <>250ma charging current for battery detection
						MTC_Stop_Charge_Discharge();
						Chk_Bat_State = BAT_CHK_WAIT_CHARGE;
						Chk_Battery_Timer = 200;  // 400 ms tempo
						Set_Duty_for_Current_Ref(150);  // <>250ma charging current for battery detection
						MTC_Charge();
						SetBit(Flag_1,Freeze_RTC);
						previous_state = DISCHARGE_1;
						State = CHECK_BATTERY_CONNECTED;
						}*/
					}
				break;
			
			case DISCHARGE_2:
				Key_Menu_Discharge();
				if (ValBit(Flag_1, Chk_Bat_Capacity))  // every 30 sec
					{
					ClrBit(Flag_1, Chk_Bat_Capacity);
					
					Load_Buffer_LCD(9,12);  // discharge
					RTC_Compute(12,RTC_hour,RTC_min,1);
					Blinking_Flag_line1 = 0x1f;  // 'discharge' blinking
					u16HexToDec_LCD(Get_Battery_Voltage(),0,0);
					capa = Get_Capacity();
					u16HexToDec_LCD(capa,8,1);
					}
				
				if (ValBit(Flag_1,SAMP_EVT))  // every 10 ms
					{
					u16 temp;  // 12,5% of Vcutoff 
					
					ClrBit(Flag_1,SAMP_EVT);	
					current = Get_Current();
//					temp = (u16)(100*( (Model.VCutoff/8) + Model.VCutoff ) );
					temp = (u16)( ((100*Model.VCutoff)/8) + (100*Model.VCutoff ) );
					if (temp > 8500) temp = 8500;  // max 8.5V for PI loop compatibility
					
					if ( (current >= Model.I_Discharge_Start) && (Get_Battery_Voltage() < temp) )
						Set_Duty_for_Current_Ref(regul_PI(0,(temp)));
					else if ( (current >= Model.I_Discharge_Stop) && (current < Model.I_Discharge_Start) )	
						Set_Duty_for_Current_Ref(regul_PI(0,(temp)));
					else if ( (current < Model.I_Discharge_Stop) && (Get_Battery_Voltage() >= temp) )	
						Set_Duty_for_Current_Ref(regul_PI(0,(temp)));
					//else if ((current <= Model.I_Discharge_Stop)	&& (Get_Battery_Voltage() >= Model.VCutoff))
						//Set_Duty_for_Current_Ref(regul_PI(0,(Model.VCutoff)));
					else if (current < (Model.I_Discharge_Stop - (Model.I_Discharge_Stop/8))) Set_Duty_for_Current_Ref(regul_PI(Model.I_Discharge_Stop,0));
						
					Load_Buffer_LCD(9,12);  // discharge
					RTC_Compute(12,RTC_hour,RTC_min,1);
					Blinking_Flag_line1 = 0x1f;  // 'discharge' blinking
					Blinking_Flag_line2 = 0xffff;  // 'discharge' blinking
					temp = Get_Battery_Voltage();
					u16HexToDec_LCD(temp,0,0);
					u16HexToDec_LCD(capa,8,1);  // display capacity
					
					if (temp >= (u16)(100*Model.VCutoff))	VCUTOFF_Timer = 120; // 6 sec voltage underflow detection Vbat = vcutoff + 12.5%
					else if (VCUTOFF_Timer == 0)	
						{
						Set_Duty_for_Current_Ref(0);  // 
						MTC_Stop_Charge_Discharge();
						Reset_RTC();
						previous_state = DISCHARGE_1;  // restart from discharge 1
						State = WAIT_FOR_CHARGE;
						break;
						}
					
			/*		if ( (Get_Current() < 50)	&& (MaxPiOut == TRUE) )// chk if battery still connected
						{
						Set_Duty_for_Current_Ref(0);  // <>250ma charging current for battery detection
						MTC_Stop_Charge_Discharge();
						Chk_Bat_State = BAT_CHK_WAIT_CHARGE;
						Chk_Battery_Timer = 200;  // 400 ms tempo
						Set_Duty_for_Current_Ref(150);  // <>250ma charging current for battery detection
						MTC_Charge();
						SetBit(Flag_1,Freeze_RTC);
						previous_state = DISCHARGE_1;
						State = CHECK_BATTERY_CONNECTED;
						} */
					}
				break;
			
			case WAIT_FOR_CHARGE:
				Key_Menu_Wait_For_Charge();
				if (Model.I_Charge <= CHARGE_OFF)	// charge disabled?
					{
					State = END_DISCHARGE;	
					SetBit(Flag_1,Freeze_RTC);
					break;
					}
				if (RTC_min >= 3)	
					{
					if (ValBit(Flag_1,Discharge_Interrupt_By_User))	Blanking_Minutes = 0;  // no blanking window
					else	Blanking_Minutes = 20;  // 20 minutes blanking window for charging process
					ClrBit(Flag_1,Discharge_Interrupt_By_User);  // clear the flag
					State = MENU_2; // 3 minutes elapsed?
					battery_voltage = Get_Battery_Voltage();
					}
				Load_Buffer_LCD(29,30);  // charge line 1, line 2
				RTC_Compute(12,2-RTC_min,(u8)((1200-RTC_sec)/20),2);  // line 2
				u16HexToDec_LCD(capa,2,1);  // display capacity
				Blinking_Flag_line1 = 0xffff;// 
				Blinking_Flag_line2 = 0xffff;// 3 min countdown 
				break;

			case MENU_2:
				{
				u8 i;
				for (i=0;i<=19;i++)	Buffer[i]=0;  // reset buffer
				}
				Reset_RTC();
				Set_Duty_for_Current_Ref(0); 
				MTC_Charge();
				Load_Buffer_LCD(10,11);  // charge line 1, line 2
				Blinking_Flag_line1 = 0x00ff;// 'charging' blinking
				Blinking_Flag_line2 = 0xffff;// 
				RTC_Compute(12,RTC_hour,RTC_min,1);  // line 1
				ClrBit(Flag_1, SAMP_EVT);
				ClrBit(Flag_1, Chk_Buffer);
				Init_PI();  // reset integral trerm
				battery_voltage = Get_Battery_Voltage();
				if (Model.LiPO == TRUE) State = CHARGE_LIPO_PHASE_1; // 2 LiPO cells??
				else State = CHARGE_NIMH;
 				break;
			
			case CHARGE_NIMH: 
				if( (RTC_hour >= ((u8)((Model.Timeout)>>8)) ) && (RTC_min >= (u8)(Model.Timeout & 0xff)) ) 
					{
					MTC_Stop_Charge_Discharge();
					Set_Duty_for_Current_Ref(0);   
					State = TIMEOUT;
					break;
					}
				
				if (ValBit(Flag_1,SAMP_EVT))
					{
					ClrBit(Flag_1,SAMP_EVT);	
					previous_current_ref = regul_PI(Model.I_Charge,0);
					Set_Duty_for_Current_Ref(previous_current_ref);
					
					Load_Buffer_LCD(10,11);  // charge line 1, line 2
					RTC_Compute(12,RTC_hour,RTC_min,1);  // line 1 -> RTC
 					Blinking_Flag_line1 = 0xff;// charge blinking
					u16HexToDec_LCD(battery_voltage,0,0);
					current = Get_Current();
					u16HexToDec_LCD(current,9,1); // line 2
					}

				if (ValBit(Flag_1, Chk_Buffer) ) // 5 sec elapsed ?	
					{
					u8 temp=0;
					
					ClrBit(Flag_1, Chk_Buffer);

					if ( (ADC_Get_10bits(CONVERT_AIN0) > No_BATT_CHARGE) )	temp = 1;  // battery disconnected first check?

					MTC_Stop_Charge_Discharge();
					Wait(10);  // 20ms 

					if (Model.I_Charge <= 500)	Set_Duty_for_Current_Ref(150);	 // <> 750 mA discharging current
					else if (Model.I_Charge <= 1500)	Set_Duty_for_Current_Ref(300);	 // <> 1.5A discharging current
					else if (Model.I_Charge <= 2500)	Set_Duty_for_Current_Ref(500);	 // <> 2.5A discharging current
					else Set_Duty_for_Current_Ref(800);	 // <> 4A discharging current
					MTC_Discharge();
					Wait(60); // 120 ms delay

					if ( (ADC_Get_10bits(CONVERT_AIN0) < No_BATT_DISCHARGE) &&	(temp == 1) ) // battery disconnected second check?
						{
						Set_Duty_for_Current_Ref(0);  // <>250ma charging current for battery detection
						MTC_Stop_Charge_Discharge();
						
						Chk_Bat_State = BAT_CHK_WAIT_CHARGE;
						Chk_Battery_Timer = 200;  // 400 ms tempo
						
						ClrBit(MCRA,3); // voltage mode
						Set_Duty_for_Current_Ref(250);  // 
						Set_Duty_for_Voltage_Mode(150);
 						MTC_Charge();
						SetBit(Flag_1,Freeze_RTC);
						previous_state = CHARGE_NIMH;
						State = CHECK_BATTERY_CONNECTED;
						break;
						}

					MTC_Stop_Charge_Discharge();
					Wait(10); // 20 ms

					Load_Buffer_LCD(10,11);  // charge line 1, line 2
					Blinking_Flag_line1 = 0xff; // 'charging' blinking
					Blinking_Flag_line2 = 0xffff; // 
					RTC_Compute(12,RTC_hour,RTC_min,1);  // line 1
					battery_voltage = Get_Battery_Voltage();
					u16HexToDec_LCD(battery_voltage,0,0);
					u16HexToDec_LCD(current,9,1);
					
//					MTC_Stop_Charge_Discharge();
					//Wait(10); // 20 ms   // modified 16/11/2006
					
					if ((Chk_Slope() == TRUE) && (Blanking_Minutes == 0) )// NiCD/NiMh & end of blanking window?
							{
							Set_Duty_for_Current_Ref(0);  //
							MTC_Stop_Charge_Discharge();
							RTC_Hour_Charge_Stop = RTC_hour;
							RTC_Min_Charge_Stop = RTC_min;
							State = END_CHARGE;
							break;
							}
							
					ClrBit(MCRA,3); // voltage mode
					Set_Duty_for_Current_Ref(250);  //
					Set_Duty_for_Voltage_Mode(120);
					MTC_Charge();
					Wait(5); // 10 ms

					SetBit(MCRA,3); // current mode

					previous_current_ref -= (u16)(previous_current_ref/8);
					Set_Duty_for_Current_Ref(previous_current_ref);
					Wait(5); // 10 ms
					}

					Key_Menu_Charge();
				break;
	
			case CHARGE_LIPO_PHASE_1: 
				if( (RTC_hour >= ((u8)((Model.Timeout)>>8)) ) && (RTC_min >= (u8)(Model.Timeout & 0xff)) ) 
					{
					MTC_Stop_Charge_Discharge();
					Set_Duty_for_Current_Ref(0);  // 
					State = TIMEOUT;
					break;
					}
				
				if (ValBit(Flag_1,SAMP_EVT))
					{
					ClrBit(Flag_1,SAMP_EVT);	
					Set_Duty_for_Current_Ref(regul_PI(Model.I_Charge,0));
					
					Load_Buffer_LCD(10,11);  // charge line 1, line 2
					RTC_Compute(12,RTC_hour,RTC_min,1);  // line 1 -> RTC
 					Blinking_Flag_line1 = 0xff;// charge blinking
					Blinking_Flag_line2 = 0xffff; // 
					u16HexToDec_LCD(battery_voltage,0,0);
					current = Get_Current();
					u16HexToDec_LCD(current,9,1); // line 2
					}
				
				if (ValBit(Flag_1, Chk_Buffer)) 	
					{
					ClrBit(Flag_1, Chk_Buffer);
				
					battery_voltage = Get_Battery_Voltage();
					if (Model.LiION == TRUE)
						{
						if (battery_voltage >= _2LiION_Cells_V_Cutoff)
							{
							State = CHARGE_LIPO_PHASE_2;
							break;
							}
						}
					else
						{
						if (battery_voltage >= _2LiPO_Cells_V_Cutoff)
							{
							State = CHARGE_LIPO_PHASE_2;
							break;
							}
						}
					}

				//	if ( (Get_Current() < 50)	&& (MaxPiOut == TRUE) )// chk if battery still connected
					if ( (ADC_Get_10bits(CONVERT_AIN0) > No_BATT_CHARGE) && (Get_Current() == 0) )// chk if battery still connected
						{
						Set_Duty_for_Current_Ref(0);  // <>250ma charging current for battery detection
						MTC_Stop_Charge_Discharge();
						Chk_Bat_State = BAT_CHK_WAIT_CHARGE;
						Chk_Battery_Timer = 200;  // 400 ms tempo
		
						ClrBit(MCRA,3); // voltage mode
						Set_Duty_for_Current_Ref(250);  // 
						Set_Duty_for_Voltage_Mode(150);
						MTC_Charge();

						SetBit(Flag_1,Freeze_RTC);
						previous_state = CHARGE_LIPO_PHASE_1;
						State = CHECK_BATTERY_CONNECTED;
						}
					
					Key_Menu_Charge();
				break;
	
			case CHARGE_LIPO_PHASE_2: 
				if( (RTC_hour >= ((u8)((Model.Timeout)>>8)) ) && (RTC_min >= (u8)(Model.Timeout & 0xff)) ) 
					{
					MTC_Stop_Charge_Discharge();
					Set_Duty_for_Current_Ref(0);  // 
					State = TIMEOUT;
					break;
					}
				
				if (ValBit(Flag_1,SAMP_EVT))
					{
					ClrBit(Flag_1,SAMP_EVT);	
					if (Model.LiION == TRUE) Set_Duty_for_Current_Ref(regul_PI(0,_2LiION_Cells_V_Cutoff));  // regul voltage at 8,2V
					else Set_Duty_for_Current_Ref(regul_PI(0,_2LiPO_Cells_V_Cutoff));  // regul voltage at 8,4V
					
					Load_Buffer_LCD(10,11);  // charge line 1, line 2
					RTC_Compute(12,RTC_hour,RTC_min,1);  // line 1 -> RTC
 					Blinking_Flag_line1 = 0xff;// charge blinking
 					Blinking_Flag_line2 = 0xffff; 
					u16HexToDec_LCD(battery_voltage,0,0);
					u16HexToDec_LCD(Get_Current(),9,1); // line 2
					}
				
				if (ValBit(Flag_1, Chk_Buffer)) 	
					{
					u16 current_threshold;

					ClrBit(Flag_1, Chk_Buffer);
					
					battery_voltage = Get_Battery_Voltage();
					
					if ((Model.I_Charge)>700) current_threshold = (u16)(Model.I_Charge/10);
					else current_threshold = 70; // force to 70mA
					
					if (Get_Current() <= current_threshold) // charge finished?
							{
							Set_Duty_for_Current_Ref(0);  // 
							MTC_Stop_Charge_Discharge();
							RTC_Hour_Charge_Stop = RTC_hour;
							RTC_Min_Charge_Stop = RTC_min;
							State = END_CHARGE;
							break;
							}
					}

				//	if ( (Get_Current() < 50)	&& (MaxPiOut == TRUE) )// chk if battery still connected
					if ( (ADC_Get_10bits(CONVERT_AIN0) > No_BATT_CHARGE) && (Get_Current() == 0) )// chk if battery still connected
						{
						Set_Duty_for_Current_Ref(0);  // <>250ma charging current for battery detection
						MTC_Stop_Charge_Discharge();
						Chk_Bat_State = BAT_CHK_WAIT_CHARGE;
						Chk_Battery_Timer = 200;  // 400 ms tempo
						

						ClrBit(MCRA,3); // voltage mode
						Set_Duty_for_Current_Ref(250);  // 
						Set_Duty_for_Voltage_Mode(150);
						MTC_Charge();

						SetBit(Flag_1,Freeze_RTC);
						previous_state = CHARGE_LIPO_PHASE_1;
						State = CHECK_BATTERY_CONNECTED;
						}

					Key_Menu_Charge();
				break;
	
			case TIMEOUT:
					Buzzer();
					Load_Buffer_LCD(20,19);  // time out, charge line 1, line 2
					Blinking_Flag_line1 = 0x0000; // 
					Blinking_Flag_line2 = 0xffff; // 
					u16HexToDec_LCD(Get_Battery_Voltage(),0,0);
					u16HexToDec_LCD(capa,8,1);  // 
					Key_Menu_Timeout();
				break;

			case END_CHARGE:
				Buzzer();
				Load_Buffer_LCD(18,19);  // line 1, line 2
				u16HexToDec_LCD(capa,8,1);  // 
				RTC_Compute(11,RTC_Hour_Charge_Stop,RTC_Min_Charge_Stop,1);  // line 1
				u16HexToDec_LCD(Get_Battery_Voltage(),0,0);
				Blinking_Flag_line1 = 0x003f; // charge OK blinking
				Blinking_Flag_line2 = 0xffff; // 
				Key_Menu_End_Charge();
				break;
	
			case END_DISCHARGE:
				Buzzer();
				Load_Buffer_LCD(16,17);  // charge line 1, line 2
				u16HexToDec_LCD(capa,8,1);  // 
				RTC_Compute(11,RTC_hour,RTC_min,1);  // line 1
				u16HexToDec_LCD(Get_Battery_Voltage(),0,0);
				Blinking_Flag_line1 = 0x003f; // discharge done
				Blinking_Flag_line2 = 0xffff; // 
				Key_Menu_End_Charge();
				break;
	
			case CHARGE_INTERRUPTED:
				Buzzer();
				Load_Buffer_LCD(25,19);  // line 1, line 2
				u16HexToDec_LCD(capa,8,1);  // 
				RTC_Compute(11,RTC_Hour_Charge_Stop,RTC_Min_Charge_Stop,1);  // line 1
				u16HexToDec_LCD(Get_Battery_Voltage(),0,0);
				Blinking_Flag_line1 = 0x003f; // charge OK blinking
				Blinking_Flag_line2 = 0xffff; // 
				Key_Menu_End_Charge();
				break;
	
			case MENU_CALIB_1:
				Load_Buffer_LCD(21,22);  // line 1, line 2
				u16HexToDec_LCD(Get_Battery_Voltage(),8,0);
				Blinking_Flag_line1 = 0xffff; // line 2 blinking
				Blinking_Flag_line2 = 0x0000; // 
				Key_Menu_Calib_1();
				break;

			case MENU_CALIB_2:
				MTC_Discharge();
				Set_Duty_for_Current_Ref(400);  // <> 2A
				Load_Buffer_LCD(23,24);  // line 1, line 2
				u16HexToDec_LCD(Get_Current(),8,1); // line 2
				Blinking_Flag_line1 = 0xffff; // line 2 blinking
				Blinking_Flag_line2 = 0x0000; // 
				Key_Menu_Calib_2();
				break;
			
			case OVERTEMP:
				Load_Buffer_LCD(26,27);  // line 1, line 2
				Blinking_Flag_line1 = 0x0000; // line 1 & 2 blinking
				Blinking_Flag_line2 = 0x0000; // 
				if (Temperature_Protection() == FALSE)	
					{
					State = previous_state;
					ClrBit(Flag_1,Freeze_RTC);
					Set_Duty_for_Current_Ref(0);   
					
					Init_PI();
					if ( (State == CHARGE_NIMH) || (State == CHARGE_LIPO_PHASE_1) || (State == CHARGE_LIPO_PHASE_2)	)	MTC_Charge();
					else if ( (State == DISCHARGE_1) || (State == DISCHARGE_2) ) MTC_Discharge();	
					else MTC_Stop_Charge_Discharge();

					Blinking_Flag_line1 = Previous_Blinking_Flag_line1;
					Blinking_Flag_line2 = Previous_Blinking_Flag_line2;
					}
				break;
			}
} // main loop
}


/*** (c) 2006 ****************** END OF FILE ***/
