/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  lcd.h
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   LCD routine prototypes              

******************************************************************************/
#ifndef LDC_H
#define LDC_H


extern u8 LCD_Flag;
#define LCD_OK		1	// 0 not connected, 1 connected
#define LCD_BLINK_ON_OFF		2	// used for blinking state


extern u16 Blinking_Flag_line1;	// xxxxxxxx xxxxxxxx   bit x at position n -> blinking if set at 0, else not blinking (1)
extern u16 Blinking_Flag_line2; // same as above
extern unsigned const disp_message[];
extern u8 menu_index;
extern u8 buffer_LCD_Line_1[16], buffer_LCD_Line_2[16];

void LCD_Startup_Screen(void);
void LCD_No_EEPROM(void);
void LCD_send_inst(unsigned char);
BOOL chk_busy(void);
void LCD_send_char(unsigned char);
void LCD_Init(void);
void Clear_Buffer_LCD(void);

void Load_Buffer_LCD(u8,u8);
void LCD_send_Buffer_LCD_to_display(void);

void LCD_send_message_to_display(u8,u8);

void u16HexToDec_LCD(u16,u8,u8);
void VcutOff_to_LCD(u8, u8);
void LCD_Detect(void);
void RTC_Compute(u8,u8,u8,u8);
void Blinking(void);
void Model_Display(void);

#endif
/**************** (c) 2006 Florent COSTE **********************/
