/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  lcd.c
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   LCD control routines
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. THE AUTHOR 
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  


#include "lib.h"   // Predifined libraries working at bit level 
#include "ST7MC_hr.h"      
#include "it_ST7MC.h"
#include "timer.h"
#include "i2c.h" 
#include "ports.h" 
#include "lcd.h" 


#define E            (Port_E * 8 + 7 - 2)    // old
#define RW           (Port_E * 8 + 7 - 1)
#define RS           (Port_E * 8 + 7 - 0)
/*
#define E            (Port_E * 8 + 7 - 0)    
#define RW           (Port_E * 8 + 7 - 1)
#define RS           (Port_E * 8 + 7 - 2)
*/
#define LCD_D4       (Port_D * 8 + 7 - 0)    
#define LCD_D5       (Port_D * 8 + 7 - 1)    
#define LCD_D6       (Port_D * 8 + 7 - 2)    
#define LCD_D7       (Port_D * 8 + 7 - 3)    


#define DDRAM_Adress_Line2	0xc0
#define DDRAM_Adress_Line1	0x80
#define	init_LCD	0x28
#define LCD_ON		0x0c
#define LCD_OFF		0x08
#define LCD_Clear	0x01    


u16 Blinking_Flag_line1 = 0xffff;
u16 Blinking_Flag_line2 = 0xffff;
u8 buffer_LCD_Line_1[16], buffer_LCD_Line_2[16], Previous_buffer_LCD_Line_1[16], Previous_buffer_LCD_Line_2[16], LCD_Flag;
u8 menu_index;


void Save_Buffer_LCD(void);
void Restore_Buffer_LCD(void);


unsigned const disp_message[]={
	'*','*',' ',' ','T','h','e',' ','C','U','B','E',' ',' ','*','*',     // message 0
	'B','y',' ','F','l','o','r','e','n','t',' ','C','O','S','T','E',     // message 1
	' ',' ','f','o','r',' ','E','L','E','K','T','O','R',' ',' ',' ',     // message 2
	' ',' ','V','e','r','s','i','o','n',' ',' ','1','.','0',' ',' ',     // message 3
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',     // message 4
	'M','o','d','e','l',' ',' ',' ',' ',' ',' ','t',' ','h',' ',' ',     // message 5
	'D','-','-','-','-',/*'>'*/0x7e,'-','-','-','-',' ','C',' ','O','f','f',     // message 6
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','L','i','/','P','O',' ',     // message 7
	'C','u','t',' ','o','f','f',' ',' ',' ','.',' ','0','V',' ',' ',     // message 8 
	'D','i','s','c','h','a','r','g','i','n','g',' ',' ','h',' ','m',     // message 9
	'C','h','a','r','g','i','n','g',' ',' ',' ',' ',' ','h',' ','m',     // message 10
	' ','.',' ',' ','V',' ',' ','I','=',' ',' ',' ',' ','m','A',' ',     // message 11
	' ','.',' ',' ','V',' ','C','=',' ',' ',' ',' ','m','A','/','h',     // message 12
	' ',' ',' ','c','o','n','n','e','c','t','e','d',' ',' ',' ',' ',     // message 13
	' ',' ','N','o',' ',' ','b','a','t','t','e','r','y',' ',' ',' ',     // message 14
	'D','i','s','c','h','.','O','F','F',' ',' ','C',' ',' ',' ',' ',     // message 15
	'D','i','s','c','h','.','d','o','n','e',' ',' ','h',' ',' ','m',     // message 16
	' ','.',' ',' ','V',' ','C','=',' ',' ',' ',' ','m','A','/','h',     // message 17
	'C','h','a','r','g','e',' ','O','K',' ',' ',' ','h',' ',' ','m',     // message 18
	' ','.',' ',' ','V',' ','C','=',' ',' ',' ',' ','m','A','/','h',     // message 19
	' ',' ',' ',' ','T','i','m','e',' ','o','u','t',' ',' ',' ',' ',     // message 20
	'C','a','l','i','b','r','a','t','i','o','n',' ',' ',' ','#','1',     // message 21
	' ','I','n','p','u','t',' ',' ',' ','.',' ',' ','V',' ',' ',' ',     // message 22
	'C','a','l','i','b','r','a','t','i','o','n',' ',' ',' ','#','2',     // message 23
	' ','I','n','p','u','t',' ',' ',' ',' ',' ',' ','m','A',' ',' ',     // message 24
	'C','h','.','S','t','o','p','p','e','d',' ',' ','h',' ',' ','m',     // message 25
	' ',' ','T','e','m','p','e','r','a','t','u','r','e',' ',' ',' ',     // message 26
	' ','P','r','o','t','e','c','t','i','o','n',' ','O','N',' ',' ',     // message 27
	' ',' ',' ',' ',' ',' ',' ',' ',' ','N','i','M','h','/','C','D',     // message 28
	' ','D','i','s','c','h','a','r','g','e',' ','d','o','n','e',' ',     // message 29
	'C','=',' ',' ',' ',' ','m','A','/','h',' ',' ',' ',':',' ',' ',     // message 30
	' ',' ','C','h','e','c','k',' ','E','E','P','R','O','M',' ',' ',     // message 31
	' ',' ',' ','C','o','n','n','e','c','t','i','o','n',' ',' ',' ',     // message 32
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','L','i','/','I','O','N'      // message 33
	};                     




BOOL chk_busy(void)  // return TRUE if busy, else FALSE
{
u8 temp;

BitClr(E);
BitClr(RS);

PDDR = 0x08; // PD3 high level 
PDOR &= ~0x0f;

PDDDR &= ~0x0f;

BitSet(RW);
BitSet(E);

if (BitVal(LCD_D7)) temp = TRUE;   // first 4 bits
else temp = FALSE;

BitClr(E);
BitClr(RW);
Nop();
BitSet(RW);  // last 4 bits
BitSet(E);
Nop();
BitClr(E);
BitClr(RW);

PDDDR |= 0x0f;
PDOR |= 0x0f;

return(temp);
}        


void LCD_Init(void)
{
LCD_Timer = 50;  // 100 ms timeout
SetBit(LCD_Flag,LCD_OK);

while (chk_busy() == TRUE) 
	{
	if (LCD_Timer == 0) 
		{
		Beep_LCD_Fault();
		}
	}
LCD_send_inst(init_LCD);
LCD_send_inst(LCD_ON);
LCD_send_inst(LCD_Clear);
}


void data_bus_load(unsigned char data)
{
PDDR = data&0x0f;
}


void LCD_send_inst(unsigned char inst)
{
BitClr(RW);
data_bus_load((u8)(inst>>4));   // 4 bits communication protocol

BitClr(RS);
BitSet(E);
Nop();
BitClr(E);
BitSet(RS);

data_bus_load((u8)(inst&0x0f));  // 1 line

BitClr(RS);
BitSet(E);
Nop();
BitClr(E);
BitSet(RS);              

while (chk_busy()== TRUE) {};
}


void LCD_send_char(unsigned char chr)
{
BitClr(RW);
data_bus_load((u8)(chr>>4));   // 4 bits communication protocol

BitSet(RS);
BitSet(E);
Nop();
BitClr(E);
BitClr(RS);

data_bus_load((u8)(chr&0x0f));  // 1 line

BitSet(RS);
BitSet(E);
Nop();
BitClr(E);
BitClr(RS);   

while (chk_busy()== TRUE) {};
}




void LCD_send_Buffer_LCD_to_display(void)
{
unsigned char i;

LCD_send_inst(DDRAM_Adress_Line1);

for (i=0;i<=15;i++)	LCD_send_char(buffer_LCD_Line_1[i]);

LCD_send_inst(DDRAM_Adress_Line2);
for (i=0;i<=15;i++)	LCD_send_char(buffer_LCD_Line_2[i]);
}



void LCD_send_message_to_display(u8 message_number1,u8 message_number2)
{
u8 i;

LCD_send_inst(LCD_Clear);

for (i=0;i<=15;i++)	LCD_send_char(disp_message[message_number1*16+i]);

LCD_send_inst(DDRAM_Adress_Line2);
for (i=0;i<=15;i++)	LCD_send_char(disp_message[message_number2*16+i]);
}    	    



void Clear_buffer_LCD(void)
{
u8 i;

for (i=0;i<=15;i++) 
	{
	buffer_LCD_Line_1[i] = ' ';
	buffer_LCD_Line_2[i] = ' ';
	}
Save_Buffer_LCD();
}



void u16HexToDec_LCD(u16 hex, u8 pos, u8 type)  // type = 0 for voltage, 1 for current display
{
u8 b,c,d,e;

if (type == 0) hex += 5; // to round correctly the data  eg 4398 + 5 = 4403 = 4,40V

b = hex/1000;
c = (hex - b*1000)/100;
d = (hex - b*1000 - c*100)/10;

if (type == 0)
	{
	if (b >= 10)		
		{
		buffer_LCD_Line_2[pos] = '1'; 
		buffer_LCD_Line_2[pos+1] = (u8)('0' + b - 10);
		buffer_LCD_Line_2[pos+2] = '.';
		buffer_LCD_Line_2[pos+3] = (u8)('0' + c);
		}
	else
		{
		buffer_LCD_Line_2[pos] = (u8)('0' + b); 
		buffer_LCD_Line_2[pos+2] = (u8)('0' + c);
		buffer_LCD_Line_2[pos+3] = (u8)('0' + d);
		}
	}	
else // current display
	{
	e = (hex - b*1000 - c*100 - d*10);
	
	if ( (b == 0)	&& (c == 0) && (d == 0) )
		{
		buffer_LCD_Line_2[pos] = (u8)(' '); 
		buffer_LCD_Line_2[pos+1] = (u8)(' ');
		buffer_LCD_Line_2[pos+2] = (u8)(' ');
		}
	else if  ( (b == 0)	&& (c == 0) )	
		{
		buffer_LCD_Line_2[pos] = (u8)(' '); 
		buffer_LCD_Line_2[pos+1] = (u8)(' ');
		buffer_LCD_Line_2[pos+2] = (u8)('0' + d);
		}
	else if  (b == 0)
		{
		buffer_LCD_Line_2[pos] = (u8)(' '); 
		buffer_LCD_Line_2[pos+1] = (u8)('0' + c);
		buffer_LCD_Line_2[pos+2] = (u8)('0' + d);
		}
	else 
		{
		buffer_LCD_Line_2[pos] = (u8)('0' + b); 
		buffer_LCD_Line_2[pos+1] = (u8)('0' + c);
		buffer_LCD_Line_2[pos+2] = (u8)('0' + d);
		}
	buffer_LCD_Line_2[pos+3] = (u8)('0' + e);
	}		
Save_Buffer_LCD();
}




void Load_Buffer_LCD(u8 message_number_line1,u8 message_number_line2)
{
u8 i;

for (i=0;i<=15;i++) buffer_LCD_Line_1[i] = disp_message[message_number_line1*16+i];
for (i=0;i<=15;i++) buffer_LCD_Line_2[i] = disp_message[message_number_line2*16+i];
Save_Buffer_LCD();
}


 
void VcutOff_to_LCD(u8 data, u8 offset)
{
u8 a,b,c;

a=data/10;
b=((u8)data-(u8)a*10);

buffer_LCD_Line_2[0+offset] = '0' + a;
buffer_LCD_Line_2[2+offset] = '0' + b;
}




/*-----------------------------------------------------------------------------
ROUTINE Name :  LCD_Startup_Screen

Description:	

Input/Output:	none
Comments: 	None
-----------------------------------------------------------------------------*/
void LCD_Startup_Screen(void)
{
LCD_send_message_to_display(0,1);
Wait(750); // 1.5 sec tempo

LCD_send_message_to_display(2,3);
Wait(750); // 1.5 sec tempo

Load_Buffer_LCD(2,3);
}
 
 
/*-----------------------------------------------------------------------------
ROUTINE Name :  LCD_No_EEPROM

Description:	

Input/Output:	none
Comments: 	None
-----------------------------------------------------------------------------*/
void LCD_No_EEPROM(void)
{
LCD_send_message_to_display(31,32);
}
 


/*-----------------------------------------------------------------------------
ROUTINE Name :  LCD_Detect

Description:	

Input/Output:	none/boolean
Comments: 		None
-----------------------------------------------------------------------------*/
void LCD_Detect(void)
{
u8 temp;

if(LCD_Timer_Detection == 0) 
	{
	LCD_Timer_Detection = 250;  // 0.5 sec before next detection
	
	if (ValBit(LCD_Flag,LCD_OK)) temp = 1;
	else temp = 0;
	
	SetBit(LCD_Flag,LCD_OK);
	LCD_Timer = 25;  // 50 ms timeout
	while (chk_busy() == TRUE) 
		{
		if (LCD_Timer == 0) 
			{
			ClrBit(LCD_Flag,LCD_OK);
			return;
			}
		}
	if (temp == 0) LCD_Init();    // previously not connected -> need to re-init
	}          
}



/*-----------------------------------------------------------------------------
ROUTINE Name :  RTC_Compute

Description:	

Input/Output:	u8/none
Comments: 		None
-----------------------------------------------------------------------------*/
void RTC_Compute(u8 pos, u8 hour, u8 min, u8 line)
{
u8 a,b;

a = (hour);

if (line == 1) buffer_LCD_Line_1[pos] = (u8)('0' + a); 
else buffer_LCD_Line_2[pos] = (u8)('0' + a); 

a = (min)/10;
b = (min - a*10);
if (line == 1)
	{
	buffer_LCD_Line_1[pos+2] = (u8)('0' + a);
	buffer_LCD_Line_1[pos+3] = (u8)('0' + b);
	}
else
	{
	buffer_LCD_Line_2[pos+2] = (u8)('0' + a);
	buffer_LCD_Line_2[pos+3] = (u8)('0' + b);
	}
Save_Buffer_LCD();
}



/*-----------------------------------------------------------------------------
ROUTINE Name :  Save_Buffer_LCD

Description:	

Input/Output:	none/none
Comments: 		None
-----------------------------------------------------------------------------*/
void Save_Buffer_LCD(void)
{
u8 i;

for (i=0;i<=15;i++)
		{
		Previous_buffer_LCD_Line_1[i] = buffer_LCD_Line_1[i];
		Previous_buffer_LCD_Line_2[i] = buffer_LCD_Line_2[i];
		}
}


/*-----------------------------------------------------------------------------
ROUTINE Name :  Restore_Buffer_LCD

Description:	

Input/Output:	none/none
Comments: 		None
-----------------------------------------------------------------------------*/
void Restore_Buffer_LCD(void)
{
u8 i;

for (i=0;i<=15;i++)
	{
	buffer_LCD_Line_1[i] = Previous_buffer_LCD_Line_1[i];
	buffer_LCD_Line_2[i] = Previous_buffer_LCD_Line_2[i];
	}
}

/*-----------------------------------------------------------------------------
ROUTINE Name :  Blinking

Description:	

Input/Output:	none/none
Comments: 		None
-----------------------------------------------------------------------------*/
void Blinking(void)
{
u8 i;

if (!ValBit(LCD_Flag,LCD_BLINK_ON_OFF))	// blinking process
//if (Display_Timer == 0) 
	{
	SetBit(LCD_Flag,LCD_BLINK_ON_OFF);	
	Save_Buffer_LCD();
	
	for (i=0;i<=15;i++)
		{
		if (!ValBit(Blinking_Flag_line1,i))	
			{
			if ( (menu_index <= 8) && (menu_index!=0) && (State == MENU_0) 
						&&  (buffer_LCD_Line_1[15-i] == 32) )
								buffer_LCD_Line_1[15-i] = 255;
			else buffer_LCD_Line_1[15-i] = ' ';
			}
		if (!ValBit(Blinking_Flag_line2,i))	buffer_LCD_Line_2[15-i] = ' ';
		}
	Display_Timer = 75; // 150ms off
	}
else 
	{
	ClrBit(LCD_Flag,LCD_BLINK_ON_OFF);
	Restore_Buffer_LCD();
	Display_Timer = 150; // 300ms on
	}
}


void Model_Display(void)
{
u8 i;
if (menu_index <= 13)
	{
	if (Model.I_Discharge_Start <= DISCHARGE_OFF) Load_Buffer_LCD(5,15);// I_Discharge_Start = 100 then no discharge!	
	else Load_Buffer_LCD(5,6);  // charge line 1, line 2
	for (i=0;i<=7;i++)	buffer_LCD_Line_1[i] = Model.Model_Name[i];
	if (Model.LiPO == FALSE)
		{
		if (Model.Sensitivity == HIGH) buffer_LCD_Line_1[9] = 'H'; // high sensitivity
		else if (Model.Sensitivity == MEDIUM_1) buffer_LCD_Line_1[9] = '2'; // medium 1 sensitivity
		else if (Model.Sensitivity == MEDIUM_2) buffer_LCD_Line_1[9] = '1'; // medium 2 sensitivity
		else buffer_LCD_Line_1[9] = 'L';  // low sensitivity
		}
	else buffer_LCD_Line_1[9] = ' '; // nothing!
	if (Model.I_Charge > CHARGE_OFF)	RTC_Compute(12,(Model.Timeout)>>8,(Model.Timeout)&0xff,1);
	else 
		{
		buffer_LCD_Line_1[12] = '-';
		buffer_LCD_Line_1[14] = '-';
		buffer_LCD_Line_1[15] = '-';			
		}
	if (Model.I_Discharge_Start > DISCHARGE_OFF) // I_Discharge_Start != 100 then discharge ON!
		{
		u16HexToDec_LCD(Model.I_Discharge_Start,1,1);
		u16HexToDec_LCD(Model.I_Discharge_Stop,6,1);
		}
	if (Model.I_Charge > CHARGE_OFF) u16HexToDec_LCD(Model.I_Charge,12,1);// I_Charge != 150 then charge ON!
	}
else
	{
/*	Load_Buffer_LCD(7,8);  // charge line 1, line 2
	for (i=0;i<=7;i++)	buffer_LCD_Line_1[i] = Model.Model_Name[i];
	if (Model.LiPO == TRUE)	buffer_LCD_Line_1[15] = 'Y'; // LiPO connected
	else buffer_LCD_Line_1[15] = 'N';  // NiMH/NiCD
	VcutOff_to_LCD(Model.VCutoff,9);*/
	if ( (Model.LiPO == TRUE)	&& (Model.LiION == TRUE) ) Load_Buffer_LCD(33,8);  
	else if ( (Model.LiPO == TRUE) && (Model.LiION == FALSE) ) 	Load_Buffer_LCD(7,8); 
	else	Load_Buffer_LCD(28,8); 
	for (i=0;i<=7;i++)	buffer_LCD_Line_1[i] = Model.Model_Name[i];
	if (Model.I_Discharge_Start <= DISCHARGE_OFF) 
		{
			for (i=0;i<=4;i++)	buffer_LCD_Line_2[9+i] = '-';
		}
	else VcutOff_to_LCD(Model.VCutoff,9);
	}
Save_Buffer_LCD();
}


/*** (c) 2006 ****************** END OF FILE ***/
