/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  i2c.h
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   i2c routine prototypes              


******************************************************************************/
#ifndef I2C_USER_H
#define I2C_USER_H


#define CRC1_Value	0x3e	
#define CRC2_Value	0x4a	
//#define CRC3_Value	0x89	
//#define CRC4_Value	0xc4	

#define PxDDR_SCL	_PDDDR
#define PxDR_SCL	_PDDR
#define SCL   6

#define PxDDR_SDA	_PDDDR
#define PxDR_SDA	_PDDR
#define SDA   7


#define I2C_EEPROM_SIZE    8    /* Max nbr of byte transmited for EEPROM.    */
#define I2C_EEP_ADR       0xA0                      /* for the EEPROM device.*/

#define TOTAL_MODELS	14
#define Model_BYTE_SIZE	(u8)16 // 16 byte + 2 bits for sensitivity
#define EEPROM_LIION_SELECT_BASE_ADRESS	2	// starting adress in EEPROM, total 2 bytes
#define EEPROM_SENSITIVITY_BASE_ADRESS	4	// starting adress in EEPROM, total 4 bytes
#define EEPROM_MODEL_1_BASE_ADRESS	8	// starting adress in EEPROM
#define EEPROM_MODEL_LiPO_VCUTOFF_BASE_ADRESS	240	// starting adress in EEPROM

/* PUBLIC VARIABLES **********************************************************/

extern u8 I2c_EepBuff [I2C_EEPROM_SIZE];
#define CRC1			I2c_EepBuff[0]
#define CRC2			I2c_EepBuff[1]
#define CRC3			I2c_EepBuff[2]
#define CRC4			I2c_EepBuff[3]

#define HIGH				3
#define MEDIUM_1		2
#define MEDIUM_2		1
#define LOW					0

struct Model_Struct {
	u8 Model_Name[8];  // model name 8 characters
	u8 Sensitivity;
	u16 I_Discharge_Start;
	u16 I_Discharge_Stop;
	u16 I_Charge;
	u16 Timeout;
	u8 VCutoff;
	BOOL LiPO;
	BOOL LiION;
}; 

#define DISCHARGE_OFF	(u8)(150)
#define CHARGE_OFF	(u8)(150)
extern struct Model_Struct Model;

/* PUBLIC FUNCTIONS **********************************************************/

void I2Cm_Tx (u8,u8,u8);
void I2Cm_Rx (u8,u8,u8);

char I2C_ReadReadBuff (void);
void  I2C_SetParEep (void);
void  I2C_EepromLoad(void);
void I2C_EepromRead(u8,u8);
void Load_Model_Parameters(u8);

#endif
/**************** (c) 2006 Florent COSTE **********************/

