/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  adc.h
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   ADC routine prototypes              


******************************************************************************/

#ifndef adc_H
#define adc_H  

/*****************************************************************************/

/* Public Constants -------------------------------------------------------- */
#define _2LiPO_Cells_V_Cutoff	(u16)8400 // 8.40Volts
#define _2LiION_Cells_V_Cutoff	(u16)8200 // 8.20Volts
#define _1LiPO_Cells_V_Cutoff	(u16)(_2LiPO_Cells_V_Cutoff/2) // 4.20Volts

#define No_BATT_CHARGE		1010  // > 4.93V
#define No_BATT_DISCHARGE		100  // < 0.488V

#define	_25deg	610
#define	_30deg	621
#define	_35deg	631
#define	_40deg	641
#define	_45deg	651
#define	_65deg	691
#define	_70deg	702
#define	_75deg	712
#define	_80deg	722
#define	_85deg	733
#define	_90deg	743
#define	_95deg	753

//#define Temperature_Threshold_High	_85deg
//#define Temperature_Threshold_Low 	_70deg
#define Temperature_Threshold_High	_80deg
#define Temperature_Threshold_Low 	_70deg

/* Public Variables -------------------------------------------------------- */
extern u32 Bat_Capacity;
extern u16 Buffer[20], max, capa;
extern u8 event;

extern u8 Flag_1;
#define Chk_Buffer									0
#define Chk_Bat_Capacity						1
#define SAMP_EVT										2
#define Discharge_Interrupt_By_User	3
#define Freeze_RTC									4
#define Temperature_Protec_ON				5	
#define LED_Status_bit_1 						6
#define LED_Status_bit_2						7

typedef enum 
{
BAT_CHK_WAIT_CHARGE,BAT_CHK_WAIT_DISCHARGE,BAT_CHK_CHARGE,BAT_CHK_DISCHARGE 
} SystStatus_Battery;

extern SystStatus_Battery Chk_Bat_State;


/* Public  macros ---------------------------------------------------------- */

/* Public Functions prototypes --------------------------------------------- */

u16 ADC_Get_10bits(u8);		// return 10 bits result (full ADC resolution)
u8 ADC_Get_8bits(u8);		// return 8 bits result only           
u16 Get_Battery_Voltage(void);
u16 Get_Current(void);
BOOL Chk_Slope(void);
BOOL Chk_Battery_connection(void);
u16 Chk_Temperature(void);
BOOL Temperature_Protection(void);
	
#endif
/**************** (c) 2006 Florent COSTE **********************/
