/**************** (c) 2006 Florent COSTE **********************

PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  ST7MC_hr.h
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :  harwdare register prototype definitions

              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

******************************************************************************/

#ifndef MAP_ST7MC_H
#define MAP_ST7MC_H


#ifdef __CSMC__							/* only for Cosmic Compiler*/         

@tiny extern volatile u8 PADR @0x00;	/* port A data register             */          
@tiny extern volatile u8 PADDR @0x01;	/* port A data direction register   */
@tiny extern volatile u8 PAOR @0x02;	/* port A option register           */  

@tiny extern volatile u8 PBDR @0x03;	/* port B data register             */          
@tiny extern volatile u8 PBDDR @0x04;	/* port B data direction register   */
@tiny extern volatile u8 PBOR @0x05;	/* port B option register           */

@tiny extern volatile u8 PCDR @0x06;	/* port C data register             */          
@tiny extern volatile u8 PCDDR @0x07;	/* port C data direction register   */
@tiny extern volatile u8 PCOR @0x08;	/* port C option register           */

@tiny extern volatile u8 PDDR @0x09;	/* port D data register             */          
@tiny extern volatile u8 PDDDR @0x0A;	/* port D data direction register   */
@tiny extern volatile u8 PDOR @0x0B;	/* port D option register           */  

@tiny extern volatile u8 PEDR @0x0c;	/* port D data register             */          
@tiny extern volatile u8 PEDDR @0x0d;	/* port D data direction register   */
@tiny extern volatile u8 PEOR @0x0e;	/* port D option register           */  

@tiny extern volatile u8 SCISR @0x18;		/* SCI status register					*/
@tiny extern volatile u8 SCIDR @0x19;		/* SCI data register					*/
@tiny extern volatile u8 SCIBRR @0x1A;		/* SCI baud rate register				*/
@tiny extern volatile u8 SCICR1 @0x1B;		/* SCI control register 1				*/
@tiny extern volatile u8 SCICR2 @0x1C;		/* SCI control register 2				*/
@tiny extern volatile u8 SCICR3 @0x1D;		/* SCI control register 3				*/
@tiny extern volatile u8 SCIERPR @0x1E;		/* SCI extended receive prescaler register		*/
@tiny extern volatile u8 SCIETPR @0x1F;		/* SCI extended transmit prescaler register		*/

@tiny extern volatile u8 ITSPR0 @0x24;          /* interrupt software priority reg0*/
@tiny extern volatile u8 ITSPR1 @0x25;          /* interrupt software priority reg1*/
@tiny extern volatile u8 ITSPR2 @0x26;          /* interrupt software priority reg2*/
@tiny extern volatile u8 ITSPR3 @0x27;          /* interrupt software priority reg3*/
@tiny extern volatile u8 EICR @0x28;            /* external interrupt control register */   

@tiny extern volatile u8 FSCR @0x29;        		/* Flash Control Status Register */

@tiny extern volatile u8 WWDGCR @0x2A;	    	/* Window Watchdog Control Register */
@tiny extern volatile u8 WWDGWR @0x2B;		    /* Window Watchdog Status Register */

@tiny extern volatile u8 MCCSR @0x2C;	/* Main Clock Control/Status Register */
@tiny extern volatile u8 MCCBCR @0x2D;	/* Main Clock Controller: Beep Control Register */

@tiny extern volatile u8 ADCCSR @0x2E;	/* ADC Control Status Register */
@tiny extern volatile u8 ADCDRH @0x2F;	/* ADC Data Register High */
@tiny extern volatile u8 ADCDRL @0x30;	/* ADC Data Register Low */

@tiny extern volatile u8 TACR2 @0x31;               /* timer A control register 2                 */
@tiny extern volatile u8 TACR1 @0x32;               /* timer A control register 1                 */
@tiny extern volatile u8 TASR @0x33;                /* timer A status register                    */
@tiny extern volatile u8 TAIC1HR @0x34;             /* timer A input capture 1 high register      */
@tiny extern volatile u8 TAIC1LR @0x35;             /* timer A input capture 1 low register       */
@tiny extern volatile u8 TAOC1HR @0x36;             /* timer A output compare 1 high register     */
@tiny extern volatile u8 TAOC1LR @0x37;             /* timer A output compare 1 low register      */
@tiny extern volatile u8 TACHR @0x38;               /* timer A counter high register              */
@tiny extern volatile u8 TACLR @0x39;               /* timer A counter low register               */
@tiny extern volatile u8 TAACHR @0x3A;              /* timer A alternate counter high register    */
@tiny extern volatile u8 TAACLR @0x3B;              /* timer A alternate counter low register     */
@tiny extern volatile u8 TAIC2HR @0x3C;             /* timer A input capture 2 high register      */
@tiny extern volatile u8 TAIC2LR @0x3D;             /* timer A input capture 2 low register       */
@tiny extern volatile u8 TAOC2HR @0x3E;             /* timer A output compare 2 high register     */
@tiny extern volatile u8 TAOC2LR @0x3F;             /* timer A output compare 2 low register      */

@tiny extern volatile u8 SICSR @0x40;               /* System Integrity Control Status Register   */

@tiny volatile u8 TBCR2 @0x41;               /* timer B control register 2                 */
@tiny volatile u8 TBCR1 @0x42;               /* timer B control register 1                 */
@tiny volatile u8 TBSR @0x43;                /* timer B status register                    */
@tiny volatile u8 TBIC1HR @0x44;             /* timer B input capture 1 high register      */
@tiny volatile u8 TBIC1LR @0x45;             /* timer B input capture 1 low register       */
@tiny volatile u8 TBOC1HR @0x46;             /* timer B output compare 1 high register     */
@tiny volatile u8 TBOC1LR @0x47;             /* timer B output compare 1 low register      */
@tiny volatile u8 TBCHR @0x48;               /* timer B counter high register              */
@tiny volatile u8 TBCLR @0x49;               /* timer B counter low register               */
@tiny volatile u8 TBACHR @0x4A;              /* timer B alternate counter high register    */
@tiny volatile u8 TBACLR @0x4B;              /* timer B alternate counter low register     */
@tiny volatile u8 TBIC2HR @0x4C;             /* timer B input capture 2 high register      */
@tiny volatile u8 TBIC2LR @0x4D;             /* timer B input capture 2 low register       */
@tiny volatile u8 TBOC2HR @0x4E;             /* timer B output compare 2 high register     */
@tiny volatile u8 TBOC2LR @0x4F;             /* timer B output compare 2 low register      */

@tiny extern volatile u8 DMCR @0x6B;              /* Debug Control Register                 */
@tiny extern volatile u8 DMSR @0x6C;              /* Debug Status Register                  */
@tiny extern volatile u8 DMBK1H @0x6D;            /* Debug Breakpoint 1 MSB MSB Register    */
@tiny extern volatile u8 DMBK1L @0x6E;            /* Debug Breakpoint 1 MSB MSB Register    */
@tiny extern volatile u8 DMBK2H @0x6F;            /* Debug Breakpoint 1 MSB MSB Register    */
@tiny extern volatile u8 DMBK2L @0x70;            /* Debug Breakpoint 1 MSB MSB Register    */

@tiny extern volatile u8 PWMDCR3 @0x74;             /* PWM AR Timer Duty Cycle Register 3         */
@tiny extern volatile u8 PWMDCR2 @0x75;             /* PWM AR Timer Duty Cycle Register 2         */
@tiny extern volatile u8 PWMDCR1 @0x76;             /* PWM AR Timer Duty Cycle Register 1         */
@tiny extern volatile u8 PWMDCR0 @0x77;             /* PWM AR Timer Duty Cycle Register 0         */
@tiny extern volatile u8 PWMCR @0x78;               /* Auto-Reload Timer Control/Status Register  */
@tiny extern volatile u8 ARTCSR @0x79;              /* Auto-Reload Timer Control/Status Register  */
@tiny extern volatile u8 ARTCAR @0x7A;              /* Auto-Reload Timer Counter Access Register  */
@tiny extern volatile u8 ARTARR @0x7B;              /* Auto-Reload Timer Auto-Reload Register     */
@tiny extern volatile u8 ARTICCSR @0x7C;            /* AR Timer Input Capture Control/Status Reg. */
@tiny extern volatile u8 ARTICR1 @0x7D;             /* AR Timer Input Capture Register 1          */
@tiny extern volatile u8 ARTICR2 @0x7E;             /* AR Timer Input Capture Register 2          */

@tiny extern volatile u8 OACSR @0x7F;	/* Operational Amplifier Control/Status register */

#else
  #error"Unsupported Compiler!"	// Compiler Defines not found! 
#endif
   
/*---CONSTANTS---*/

// LinSCI Peripheral
// SCISR
#define TDRE		((u8)0x07)		/* Transmit data bit */
#define TC			((u8)0x06)		/* Transmission complete */
#define RDRF		((u8)0x05)		/* Received data ready */
#define IDL			((u8)0x04)		/* Idle line detected  */
#define OR			((u8)0x03)		/* Overrun error */
#define NF			((u8)0x02)		/* Noise flag */
#define FE			((u8)0x01)		/* Framing error */
#define PE			((u8)0x00)		/* Parity error */

// SCICR1
#define R8			((u8)0x07)		/* Receive data bit 8 */
#define T8			((u8)0x06)		/* Transmit data bit 8 */
#define SCID		((u8)0x05)		/* Disable for low power consumption */
#define M			((u8)0x04)		/* Word length  */
#define WAKE		((u8)0x03)		/* Wake-up method */
#define PCE			((u8)0x02)		/* Parity control enable */
#define PS			((u8)0x01)		/* Parity selection */
#define PIE			((u8)0x00)		/* Parity interrupt enable */

// SCICR2
#define TIE			((u8)0x07)		/* Transmitter interrupt enable */
#define TCIE		((u8)0x06)		/* Transmission complete interrupt enable */
#define RIE			((u8)0x05)		/* Receiver interrupt enable */
#define ILIE		((u8)0x04)		/* Idle line interrupt enable  */
#define TE			((u8)0x03)		/* Transmitter enable */
#define RE			((u8)0x02)		/* Receiver enable */
#define RWU			((u8)0x01)		/* Receiver wake-up */
#define SBK			((u8)0x00)		/* Send break */


#define TX_RX_SCIBRR_9600_Bauds		0xd2		/* TX/RX 9600 bauds	*/

#define TX_RX_SCIBRR_57600_Bauds	0x00		/* TX/RX 57600 bauds	*/
#define TX_ETPR_57600_Bauds			8			/* TX 57600 bauds	*/
#define RX_ERPR_57600_Bauds			8			/* RX 57600 bauds	*/


// ADC peripheral
// ADCCSR: ADC Control/Status Register bit definition
#define EOC			((u8)0x07)		/* End of Conversion */
#define PRSC1		((u8)0x06)		/* A/D Clock Prescaler */
#define PRSC0		((u8)0x05)		/* A/D Clock Prescaler */
#define ADON		((u8)0x04)		/* A/D converter on */
#define CS3			((u8)0x03)		/* ADC Channel selection */
#define CS2			((u8)0x02)		/* ADC Channel selection */
#define CS1			((u8)0x01)		/* ADC Channel selection */
#define CS0			((u8)0x00)		/* ADC Channel selection */

#define EOC_MSK			((u8)0x80)		/* End of Conversion Mask */
#define PRSC1_MSK		((u8)0x40)		/* A/D Clock Prescaler Mask */
#define PRSC0_MSK		((u8)0x20)		/* A/D Clock Prescaler Mask */
#define ADON_MSK		((u8)0x10)		/* A/D converter on Mask */
#define CS3_MSK			((u8)0x08)		/* ADC Channel selection Mask */
#define CS2_MSK			((u8)0x04)		/* ADC Channel selection Mask */
#define CS1_MSK			((u8)0x02)		/* ADC Channel selection Mask */
#define CS0_MSK			((u8)0x01)		/* ADC Channel selection Mask */

#define PRSC_MASK		((u8)0x00)		/* Define here selected prescaler ratio */

#define CONVERT_AIN0	((u8)ADON_MSK	+ PRSC_MASK													)
#define CONVERT_AIN1	((u8)ADON_MSK 	+ PRSC_MASK										+ CS0_MSK	)
#define CONVERT_AIN2	((u8)ADON_MSK 	+ PRSC_MASK							+ CS1_MSK				)
#define CONVERT_AIN3	((u8)ADON_MSK	+ PRSC_MASK							+ CS1_MSK	+ CS0_MSK	)
#define CONVERT_AIN4	((u8)ADON_MSK	+ PRSC_MASK				+ CS2_MSK							)
#define CONVERT_AIN5	((u8)ADON_MSK	+ PRSC_MASK				+ CS2_MSK				+ CS0_MSK	)
#define CONVERT_AIN6	((u8)ADON_MSK	+ PRSC_MASK				+ CS2_MSK	+ CS1_MSK				)
#define CONVERT_AIN7	((u8)ADON_MSK	+ PRSC_MASK				+ CS2_MSK	+ CS1_MSK	+ CS0_MSK	)
#define CONVERT_AIN8	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK										)
#define CONVERT_AIN9	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK							+ CS0_MSK	)
#define CONVERT_AIN10	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK				+ CS1_MSK				)
#define CONVERT_AIN11	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK				+ CS1_MSK	+ CS0_MSK	)
#define CONVERT_AIN12	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK	+ CS2_MSK							)
#define CONVERT_AIN13	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK	+ CS2_MSK				+ CS0_MSK	)
#define CONVERT_AIN14	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK	+ CS2_MSK	+ CS1_MSK				)
#define CONVERT_AIN15	((u8)ADON_MSK	+ PRSC_MASK	+ CS3_MSK	+ CS2_MSK	+ CS1_MSK	+ CS0_MSK	)



/* Timers A&B Control Register 1 bit definition  */

#define ICIE        0x07        // Input capture interrupt enable                                    
#define OCIE        0x06        // Output compare interrupt enable                            
#define TOIE        0x05        // Timer overflow interrupt enable
#define OLVL2       0x02        // Output level 2
#define IEDG1       0x01        // Input edge 1
#define OLVL1       0x00        // Ouput level 1

/* Timers A&B Control Register 2 bit definition  */

#define OC1E        0x07        // Output compare 1 pin
#define OC2E        0x06        // Output compare 1 pin
#define OPM         0x05        // One pulse mode
#define PWM         0x04        // PWM Mode
#define IEDG2       0x01        // Input edge 2

/* Timer A&B Status register bit definition  */

#define ICF1        0x07        // Input capture 1 flag
#define OCF1        0x06        // Output compare 1 flag
#define TOF         0x05        // Timer overflow flag
#define ICF2        0x04        // Input capture 2 flag
#define OCF2        0x03        // Output compare 2 flag


/*------------------------------REGISTER BITS DEFINITION---------------------*/
// MCCSR: MCC Status register
#define TB_INT_FLAG	((u8)0x01) /* Time base interrupt flag */
#define TB_INT_EN	((u8)0x02) /* Time Base interrupt enable */
#define TB25MS		((u8)0x0C) /* Time base (Fosc2=8MHz) */
#define TB10MS		((u8)0x08) /* Time base (Fosc2=8MHz) */
#define TB4MS		((u8)0x04) /* Time base (Fosc2=8MHz) */
#define TB2MS		((u8)0x00) /* Time base (Fosc2=8MHz) */
#define SLOW_MODE	((u8)0x10) /* Slow Mode Select */
#define FOSC_2		((u8)0x00) /* Fcpu = Fosc2/2 */
#define FOSC_4		((u8)0x20) /* Fcpu = Fosc2/4 */
#define FOSC_8		((u8)0x40) /* Fcpu = Fosc2/8 */
#define FOSC_16		((u8)0x60) /* Fcpu = Fosc2/16 */
#define MCO_ENABLE	((u8)0x80) /* Main Clock Out Selection */

// MCCBCR: MCC Beep control register
#define ADSTS		((u8)0x03)		/* ADC Converter Sample Time Stretch */
#define ADCIE		((u8)0x02)		/* ADC Interrupt Enable */
#define BC1			((u8)0x01)		/* MCC Beep Control */
#define BC0			((u8)0x00)		/* MCC Beep Control */


/*---CONSTANTS---*/

/* OP-AMP: Operational Amplifier */ 

#define CMPOVR		((u8)0x80)			/* Offset Compensation Status bit */
#define OFFCMP		((u8)0x40)          /* Offset compensation start bit */
#define AVGCMP		((u8)0x20)          /* Average Compensation times selection */
#define OAON		((u8)0x10)          /* Op-Amp power on/off bit */
#define HIGHGAIN	((u8)0x08)          /* Gain range selection bit */
   

/* Window Watchdog */
#define WDGA		((u8)0x80)

#endif

/**************** (c) 2006 Florent COSTE **********************/
