/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  Misc.h
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Miscellanous routine prototypes              

******************************************************************************/
                  
#ifndef MISC_H
#define MISC_H          

/*****************************************************************************/

/* Public  macros ---------------------------------------------------------- */
// Accurate timing macros needed (works with 16 MHz CPU clock)

#ifdef __HIWARE__		// for HIWARE Compiler 
	#define Wait1us()	{__asm NOP; __asm NOP; __asm NOP; __asm NOP;}
#else
    #ifdef __CSMC__		    // test for Cosmic Compiler 
	#define Wait1us()	{_asm ("nop\n nop\n nop\n nop\n ");}
    #else
      #error"Unsupported Compiler!"	// Compiler Defines not found! 
    #endif
#endif

#define MOS_Discharge_OFF		ClrBit(PBDR,0)
#define MOS_Discharge_ON		SetBit(PBDR,0)
#define MOS_Charge_OFF		ClrBit(PBDR,4)
#define MOS_Charge_ON		SetBit(PBDR,4)

#define SET_MUX_Discharge		{MOS_Charge_OFF;MOS_Discharge_ON;}
#define SET_MUX_Charge		{MOS_Discharge_OFF;MOS_Charge_ON;}
#define SET_MUX_All_OFF		{MOS_Discharge_OFF;MOS_Charge_OFF;}


/* Public Functions prototypes --------------------------------------------- */

void Wait(u16);
void Wait100us(void);
void Wait1ms(void); 
void Chk_Power_Motor_Status(void);
void Reset_RTC(void);
void Reset_Variables(void);
void Beep_Init(void);
void Beep_LCD_Fault(void);
	
#endif
/**************** (c) 2006 Florent COSTE **********************/
