/**************** (c) 2006 Florent COSTE **********************
     
PROJECT  : ST7MC Rx battery charger
COMPILER : ST7 COSMIC

MODULE  :  misc.c
LIBRARY VERSION  :  1.0

CREATION DATE :    01.2006
AUTHOR :      Florent COSTE	

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION : Miscellanous routines   
              
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

 ******************************************************************************
 THE SOFTWARE INCLUDED IN THIS FILE IS FOR GUIDANCE ONLY. THE AUTHOR 
 SHALL NOT BE HELD LIABLE FOR ANY DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES
 WITH RESPECT TO ANY CLAIMS ARISING FROM USE OF THIS SOFTWARE.
 ******************************************************************************

******************************************************************************/  
 
#include "lib.h"
#include "ST7MC_hr.h"
#include "mtc_hr.h"
#include "mtc.h"
#include "Timer.h" 
#include "adc.h" 
#include "ports.h"   
#include "it_st7mc.h"   
#include "lcd.h" 
#include "MTC_Settings_Sensorless.h"
#include "Misc.h" 



/*-----------------------------------------------------------------------------
ROUTINE Name :  Waitxxx

Description:	Waiting routines.
Input/Output:	none/none
Comments: 		None
-----------------------------------------------------------------------------*/

void Wait(u16 time)
{
timer_2ms = time;
while (timer_2ms != 0)	
	{
	Led();
	}
}

void Wait100us(void)
{
u8 i;

for (i=0; i<18; i++)    Wait1us();
}

void Wait1ms(void)
{
u8 i;

for (i=0; i<180; i++)    Wait1us();;
}



void Reset_RTC(void)
{
RTC_hour = 0;
RTC_min = 0;
RTC_sec = 0;
}

void Reset_Variables(void)
{
u8 i;

for (i=0;i<=19;i++)	Buffer[i]=0;

menu_index = 0;
Bat_Capacity = 0;
capa = 0;
max = 0;
event = 0;
Flag_1 = 0;
Blanking_Minutes = 0;
Beep_Number = 0;
BeepState = BEEP_OFF;

MTC_Stop_Charge_Discharge();
SetBit(MCRA,3); // current mode
Set_Duty_for_Current_Ref(0);  // 
Set_Duty_for_Voltage_Mode(0);
ALL_PWM_OFF;
}


void Beep_Init(void)
{
MTC_Stop_Charge_Discharge();
PWM_T3_ON;
ClrBit(MCRA,3); // voltage mode
Set_Duty_for_Current_Ref((u16)(PWM_FREQUENCY+1));  // <>250ma charging current for battery 
Set_Duty_for_Voltage_Mode((u16)(PWM_FREQUENCY+1));
Wait(50);
Set_Duty_for_Voltage_Mode(0);
Wait(25);
Set_Duty_for_Voltage_Mode((u16)(PWM_FREQUENCY+1));
Wait(50);
Set_Duty_for_Current_Ref(0);  // <>250ma charging current for battery 
ALL_PWM_OFF;
SetBit(MCRA,3); // current mode
}

void Beep_LCD_Fault(void)
{
MTC_Stop_Charge_Discharge();
PWM_T3_ON;
ClrBit(MCRA,3); // voltage mode
Set_Duty_for_Current_Ref((u16)(PWM_FREQUENCY+1)); 
Set_Duty_for_Voltage_Mode((u16)(PWM_FREQUENCY+1));
Wait(400);
Set_Duty_for_Voltage_Mode(0);
Wait(800);
Set_Duty_for_Current_Ref(0);
ALL_PWM_OFF;
SetBit(MCRA,3); // current mode
}

/*** (c) 2006 ****************** END OF FILE ***/
