/**************** (c) 2006 Florent COSTE **********************

PROJECT  : ST7MC Rx battery charger
COMPILER : COSMIC

MODULE  :  it_ST7MC.c
LIBRARY VERSION  :  1.0.2

CREATION DATE :    08.2003
AUTHOR :      Florent COSTE

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

DESCRIPTION :   Main interrupt service routines

-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-

******************************************************************************/


#include "lib.h"
#include "it_ST7MC.h"
#include "ST7MC_hr.h" 
#include "ports.h"
#include "timer.h"
#include "mtc.h"
#include "regul.h" 
#include "wwdg.h"   
#include "adc.h"   


volatile u8 RTC_hour, RTC_min, RTC_hour_timeout, RTC_min_timeout, DebounceButton, timer_Buffer_ADC, Blanking_Minutes ;
volatile u8 PI_Sampling, LCD_Timer, LCD_Timer_Detection, Display_Timer,Blinking_Timer;
volatile u8 Chk_Battery_Timer, VCUTOFF_Timer;
volatile u8  Key_Data_Plus_rpt_counter, Key_Data_Minus_rpt_counter, Key_Function_Plus_rpt_counter, Key_Function_Minus_rpt_counter;
volatile u8	LED_Timer,LED_Display_Timer;

volatile u16 timebase_2ms, RTC_sec, Timer_Bat_Capacity, timer_2ms;
u8 RTC_Hour_Charge_Stop,RTC_Min_Charge_Stop;

#ifdef __HIWARE__				/* test for HIWARE Compiler */
#pragma TRAP_PROC SAVE_REGS		/* additional registers will be saved */
#else
#ifdef __CSMC__					/* test for Cosmic Compiler */
@interrupt						/* Cosmic interrupt handling */
#else
#error"Unsupported Compiler!"	/* Compiler Defines not found! */
#endif
#endif
/*-----------------------------------------------------------------------------
ROUTINE NAME : dummy_rt
INPUT/OUTPUT : None

DESCRIPTION  : Empty Interrupt Service Routine

COMMENTS     : all the non-connected interrupt vectors are connected to this empty function
-----------------------------------------------------------------------------*/ 
void dummy_rt(void)
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : TRAP_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : Software Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void TRAP_Interrupt(void)
{
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : MCC_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : Software Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void MCC_Interrupt(void)
{
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_0_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void PORTS_0_Interrupt(void)
{
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_1_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void PORTS_1_Interrupt(void)
{
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : PORTS_2_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : 

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void PORTS_2_Interrupt(void)
{
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : TIMB_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer A Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void TIMB_Interrupt(void)
{
unsigned int timer;

if (ValBit(TBSR,6))
	{
	timer=TBOC1HR<<8;
	timer+=TBOC1LR;

	if (Duty_fan_control != 0)
		{
		BitSet(PWM_FAN);
		timer += (u16)(Duty_fan_control);
		TBOC2HR=(u8)(timer>>8);
		TBOC2LR=(u8)timer;
		}

	timer=TBOC1HR<<8;
	timer+=TBOC1LR;
	timer+= 5000;   // int every 10 ms
	TBOC1HR=(u8)(timer>>8);
	TBOC1LR=(u8)timer;


		}                                 
	if (ValBit(TBSR,3))
		{
		TBOC2LR;
//	timer=TBOC2HR<<8;
//	timer+=TBOC2LR;
//	timer+= 10000;   // int every 10 ms
//	TBOC2HR=(u8)(timer>>8);
//	TBOC2LR=(u8)timer;
	if (Duty_fan_control != 5000)		BitClr(PWM_FAN);
		}
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : TIMA_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : timer A Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void TIMA_Interrupt(void)
{
unsigned int timer;

if (ValBit(TASR,6))
	{
	timer=TAOC1HR<<8;
	timer+=TAOC1LR;
	timer+= 50000;   // int every 50 ms
	TAOC1HR=(u8)(timer>>8);
	TAOC1LR=(u8)timer;
	
	if (VCUTOFF_Timer != 0) VCUTOFF_Timer--;

	if (!ValBit(Flag_1,Freeze_RTC))	RTC_sec ++;
	
	if (RTC_sec >= 1200)
		{
		RTC_sec = 0;
		if (Blanking_Minutes != 0) Blanking_Minutes--;
		RTC_min++;
			if (RTC_min >= 60)
				{
				RTC_min = 0;
				RTC_hour++;
				if (RTC_hour >= 10) RTC_hour = 0; // reset RTC if equal to 10h00m	
				}
		}
	
	if (timer_Buffer_ADC != 0) timer_Buffer_ADC--;
	else
		{
		timer_Buffer_ADC = 100; // voltage sampling each 5 sec
		SetBit(Flag_1, Chk_Buffer);
		}

	if (Timer_Bat_Capacity != 0) Timer_Bat_Capacity--;
	else
		{
		Timer_Bat_Capacity = 600; // chk every 30sec;
		SetBit(Flag_1, Chk_Bat_Capacity);
		}
	}                                 
if (ValBit(TASR,3))
	{
	timer=TAOC2HR<<8;
	timer+=TAOC2LR;
	timer+= 10000;   // int every 10 ms
	TAOC2HR=(u8)(timer>>8);
	TAOC2LR=(u8)timer;

	if (Key_Data_Plus_rpt_counter != 0) Key_Data_Plus_rpt_counter--;
	if (Key_Data_Minus_rpt_counter != 0) Key_Data_Minus_rpt_counter--;
	if (Key_Function_Plus_rpt_counter != 0) Key_Function_Plus_rpt_counter--;
	if (Key_Function_Minus_rpt_counter != 0) Key_Function_Minus_rpt_counter--;

	if (LED_Display_Timer != 0) LED_Display_Timer--;
	}
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : SCI_IT_Routine
INPUT/OUTPUT : None

DESCRIPTION  : SCI Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void SCI_IT_Routine(void)
{
}

/*-----------------------------------------------------------------------------
ROUTINE NAME : AVD_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : Auxiliary Voltage Detector Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void AVD_Interrupt(void)
{
}


/*-----------------------------------------------------------------------------
ROUTINE NAME : ART_Interrupt
INPUT/OUTPUT : None

DESCRIPTION  : ART Interrupt Service Routine

COMMENTS     : 
-----------------------------------------------------------------------------*/ 
@interrupt void ART_Interrupt(void)
{
ARTCSR;	// clear the flag 

	if (DebounceButton != 0) DebounceButton--;      // int. every 2ms
	if (timer_2ms != 0) timer_2ms--;
	if (Timer_WDG !=0) Timer_WDG--;
	if (LCD_Timer !=0) LCD_Timer--;
	if (LCD_Timer_Detection !=0) LCD_Timer_Detection--;
	if (Display_Timer != 0) Display_Timer--;
	if (Blinking_Timer != 0) Blinking_Timer--;
	if (Chk_Battery_Timer != 0) Chk_Battery_Timer--; 
	if (Beep_Timer != 0) Beep_Timer--; 

	if (LED_Timer != 0) 
		{
		if ( (LED_Timer == LED_ON_Time)	&& (LED_ON_Time > 0) ) BitClr(LED);	// LED on
		LED_Timer--;
		}
	else 
		{
		if (LED_ON_Time < 10)	BitSet(LED);  // LED off
		LED_Timer = 10; // 20 ms
		}

	if (PI_Sampling != 0) PI_Sampling--;
	else      
		{
		SetBit(Flag_1,SAMP_EVT);
		PI_Sampling = SAMPLING_TIME;
		}
}



/*** (c) 2006  ****************** END OF FILE ***/
