/*****************************************************
This program was produced by the
CodeWizardAVR V1.24.2c Professional
Automatic Program Generator
 Copyright 1998-2004 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.ro
e-mail:office@hpinfotech.ro

Project : ProgAUTOLAV
Version : 0.8
Date    : 31/01/2012
Author  : HERGAULT Jeremy, AUMOND Anthony                            
Company : IUT GEII Tours                            
Comments: 


Chip type           : ATmega8535
Program type        : Application
Clock frequency     : 16,000000 MHz
Memory model        : Small
External SRAM size  : 0
Data Stack size     : 128
*****************************************************/

#include <mega8535.h> 
#include <delay.h>
#include <stdio.h>

// I2C Bus functions
#asm
   .equ __i2c_port=0x18 ;PORTB
   .equ __sda_bit=0
   .equ __scl_bit=1
#endasm
#include <i2c.h>

// LM75 Temperature Sensor functions
#include <lm75.h>

// Numero des entrees ADCx
#define BAT1 0
#define BAT2 1

// Adresses capteurs de temprature
#define CAPT1 0

// Difference potentiel limite batterie en mV
#define DDP 10



#define ADC_VREF_TYPE 0xC0
// Read the AD conversion result
unsigned int read_adc(unsigned char adc_input)
{
ADMUX=adc_input|ADC_VREF_TYPE;
// Start the AD conversion
ADCSRA|=0x40;
// Wait for the AD conversion to complete
while ((ADCSRA & 0x10)==0);
ADCSRA|=0x10;
return ADCW;
}



// Alphanumeric LCD Module functions
#asm
   .equ __lcd_port=0x15 ;PORTC
#endasm
#include <lcd.h>
         
unsigned char Valeur[16];

long Tour;
long Nb_tour;
long Vitesse;

long refresh;

// External Interrupt 0 service routine
interrupt [EXT_INT0] void ext_int0_isr(void)
{
	Nb_tour++;	// Compteur de tour fonction de vitesse
	delay_ms(5);	// Attente avant de relancer une interruption
}  

// Timer 0 overflow interrupt service routine
//interrupt [TIM0_OVF] void timer0_ovf_isr(void)
interrupt [TIM0_COMP] void timer0_comp_isr(void)
{
	if(((refresh) >= 6000)||(refresh < 0))
	{
		refresh = 0;		// RAZ
		Tour = Nb_tour;
		Vitesse = ((Nb_tour)*5);// Calcul de la vitesse 
		Nb_tour = 0;		// RAZ
	} 
	refresh++;	// incrementation du compteur de rafraichissement
	//TCNT0=0; //RAZ du compteur du timer
}  


// Declare your global variables here

void main(void)
{

unsigned int UnitBat1 = 0;
unsigned int DecBat1 = 0;
unsigned int UnitBat2 = 0;   
unsigned int DecBat2 = 0;

long Bat1 = 0;
long Bat2 = 0;
long Bat = 0;

unsigned char Etat_Bat = 0;



// Input/Output Ports initialization
// Port A initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTA=0x00;
DDRA=0x00;

// Port B initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTB=0x00;
DDRB=0x00;

// Port C initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTC=0x00;
DDRC=0x00;

// Port D initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
// State7=T State6=T State5=T State4=T State3=T State2=P State1=T State0=T
PORTD=0x00;
DDRD=0x00;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 250,000 kHz
// Mode: Normal top=FFh
// OC0 output: Disconnected
TCCR0=0x03;	// F = 250kHz
TCNT0=0x00;
OCR0=0xFA;	//F = 1kHz, T=1ms

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer 1 Stopped
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: On
// INT0 Mode: Rising Edge
// INT1: Off           

// INT2: Off
GICR|=0x40;
MCUCR=0x02;
MCUCSR=0x00;
GIFR=0x40;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x02;

// ADC initialization
// ADC Clock frequency: 62,500 kHz
// ADC Voltage Reference: Int., cap. on AREF
// ADC High Speed Mode: Off
// ADC Auto Trigger Source: None
ADMUX=ADC_VREF_TYPE;
ADCSRA=0x87;
SFIOR&=0xEF;

// LCD module initialization
lcd_init(16);

// I2C Bus initialization
i2c_init();

// LM75 Temperature Sensor initialization
// thyst: 35C
// tos: 40C
// O.S. polarity: 0
lm75_init(CAPT1,35,40,0);

// Global enable interrupts
#asm("sei")

Vitesse = 0; 
refresh = 0;
Nb_tour = 0;
Tour = 0;
 
lcd_gotoxy(0,0);
lcd_putsf("Projet AUTOLAV");

lcd_gotoxy(10,1);
lcd_putsf("tr/min");

Bat1 = (read_adc(BAT1)*5)/1024;
Bat2 = (read_adc(BAT2)*5)/1024;


while (1)
      {

		delay_ms(1000);
		  
		// Lecture valeur baterie
		UnitBat1 = (read_adc(BAT1)*26)/1024;
		DecBat1 = (((read_adc(BAT1)*26)%1024)*10)/1024; // * 5
		UnitBat2 = (read_adc(BAT2)*26)/1024;
		DecBat2 = (((read_adc(BAT2)*26)%1024)*10)/1024;
		
		Bat1 = UnitBat1*10 + DecBat1;
		Bat2 = UnitBat2*10 + DecBat2;
		
		Bat = ( Bat1 + Bat2 )/2;
		
		Etat_Bat = 4*Bat - 424;		
		
		sprintf(Valeur,"%d    ", Vitesse);
		lcd_gotoxy(0,1);
		lcd_puts(Valeur);

		sprintf(Valeur, "1:%d,%dV 2:%d,%dV  ", UnitBat1, DecBat1, UnitBat2, DecBat2);
		lcd_gotoxy(0,2);
		lcd_puts(Valeur); 
		
		if(((Bat1 - Bat2) > DDP) || ((Bat2 - Bat1) > DDP))
		{
			sprintf(Valeur, "Defaut batterie ");
			lcd_gotoxy(0,3);
			lcd_puts(Valeur);		
		}
		else if((Bat1 > 136) && (Bat2 > 136))
		{
			sprintf(Valeur, "En charge         ");
			lcd_gotoxy(0,3);
			lcd_puts(Valeur);
		
		}
		else
		{
			sprintf(Valeur, "%d%%                ", Etat_Bat);
			lcd_gotoxy(0,3);
			lcd_puts(Valeur);
		}
		
		
		

      };
}
