;CodeVisionAVR C Compiler V1.24.2c Professional
;(C) Copyright 1998-2004 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.ro
;e-mail:office@hpinfotech.ro

;Chip type           : ATmega8535
;Program type        : Application
;Clock frequency     : 16,000000 MHz
;Memory model        : Small
;Optimize for        : Size
;(s)printf features  : int, width
;(s)scanf features   : long, width
;External SRAM size  : 0
;Data Stack size     : 128 byte(s)
;Heap size           : 0 byte(s)
;Promote char to int : No
;char is unsigned    : Yes
;8 bit enums         : Yes
;Enhanced core instructions    : On
;Automatic register allocation : On

	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_adc_noise_red=0x10
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@2,@0+@1
	.ENDM

	.MACRO __GETWRMN
	LDS  R@2,@0+@1
	LDS  R@3,@0+@1+1
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOV  R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOV  R30,R0
	.ENDM

	.CSEG
	.ORG 0

	.INCLUDE "main.vec"
	.INCLUDE "main.inc"

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,13
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x200)
	LDI  R25,HIGH(0x200)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x25F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x25F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0xE0)
	LDI  R29,HIGH(0xE0)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0xE0
;       1 /*****************************************************
;       2 This program was produced by the
;       3 CodeWizardAVR V1.24.2c Professional
;       4 Automatic Program Generator
;       5  Copyright 1998-2004 Pavel Haiduc, HP InfoTech s.r.l.
;       6 http://www.hpinfotech.ro
;       7 e-mail:office@hpinfotech.ro
;       8 
;       9 Project : ProgAUTOLAV
;      10 Version : 0.8
;      11 Date    : 31/01/2012
;      12 Author  : HERGAULT Jeremy, AUMOND Anthony                            
;      13 Company : IUT GEII Tours                            
;      14 Comments: 
;      15 
;      16 
;      17 Chip type           : ATmega8535
;      18 Program type        : Application
;      19 Clock frequency     : 16,000000 MHz
;      20 Memory model        : Small
;      21 External SRAM size  : 0
;      22 Data Stack size     : 128
;      23 *****************************************************/
;      24 
;      25 #include <mega8535.h> 
;      26 #include <delay.h>
;      27 #include <stdio.h>
;      28 
;      29 // I2C Bus functions
;      30 #asm
;      31    .equ __i2c_port=0x18 ;PORTB
   .equ __i2c_port=0x18 ;PORTB
;      32    .equ __sda_bit=0
   .equ __sda_bit=0
;      33    .equ __scl_bit=1
   .equ __scl_bit=1
;      34 #endasm

;      35 #include <i2c.h>
;      36 
;      37 // LM75 Temperature Sensor functions
;      38 #include <lm75.h>
;      39 
;      40 // Numero des entrees ADCx
;      41 #define BAT1 1
;      42 #define BAT2 6
;      43 
;      44 // Adresses capteurs de temprature
;      45 #define CAPT1 7
;      46 
;      47 // Difference potentiel limite batterie en mV
;      48 #define DDP 10
;      49 
;      50 
;      51 
;      52 #define ADC_VREF_TYPE 0xC0
;      53 // Read the AD conversion result
;      54 unsigned int read_adc(unsigned char adc_input)
;      55 {

	.CSEG
_read_adc:
;      56 ADMUX=adc_input|ADC_VREF_TYPE;
	LD   R30,Y
	ORI  R30,LOW(0xC0)
	OUT  0x7,R30
;      57 // Start the AD conversion
;      58 ADCSRA|=0x40;
	SBI  0x6,6
;      59 // Wait for the AD conversion to complete
;      60 while ((ADCSRA & 0x10)==0);
_0x3:
	SBIS 0x6,4
	RJMP _0x3
;      61 ADCSRA|=0x10;
	SBI  0x6,4
;      62 return ADCW;
	IN   R30,0x4
	IN   R31,0x4+1
	ADIW R28,1
	RET
;      63 }
;      64 
;      65 
;      66 
;      67 // Alphanumeric LCD Module functions
;      68 #asm
;      69    .equ __lcd_port=0x15 ;PORTC
   .equ __lcd_port=0x15 ;PORTC
;      70 #endasm

;      71 #include <lcd.h>
;      72          
;      73 unsigned char Valeur[16];

	.DSEG
_Valeur:
	.BYTE 0x10
;      74 
;      75 long Tour;
_Tour:
	.BYTE 0x4
;      76 long Nb_tour;
_Nb_tour:
	.BYTE 0x4
;      77 long Vitesse;
_Vitesse:
	.BYTE 0x4
;      78 
;      79 long refresh;
_refresh:
	.BYTE 0x4
;      80 
;      81 // External Interrupt 0 service routine
;      82 interrupt [EXT_INT0] void ext_int0_isr(void)
;      83 {

	.CSEG
_ext_int0_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
;      84 	Nb_tour++;	// Compteur de tour fonction de vitesse
	LDS  R30,_Nb_tour
	LDS  R31,_Nb_tour+1
	LDS  R22,_Nb_tour+2
	LDS  R23,_Nb_tour+3
	__SUBD1N -1
	STS  _Nb_tour,R30
	STS  _Nb_tour+1,R31
	STS  _Nb_tour+2,R22
	STS  _Nb_tour+3,R23
;      85 	delay_ms(5);	// Attente avant de relancer une interruption
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	RCALL SUBOPT_0x0
;      86 }  
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;      87 
;      88 // Timer 0 overflow interrupt service routine
;      89 //interrupt [TIM0_OVF] void timer0_ovf_isr(void)
;      90 interrupt [TIM0_COMP] void timer0_comp_isr(void)
;      91 {
_timer0_comp_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
;      92 	if(((refresh) >= 6000)||(refresh < 0))
	LDS  R26,_refresh
	LDS  R27,_refresh+1
	LDS  R24,_refresh+2
	LDS  R25,_refresh+3
	__CPD2N 0x1770
	BRGE _0x7
	RCALL __CPD20
	BRGE _0x6
_0x7:
;      93 	{
;      94 		refresh = 0;		// RAZ
	LDI  R30,0
	STS  _refresh,R30
	STS  _refresh+1,R30
	STS  _refresh+2,R30
	STS  _refresh+3,R30
;      95 		Tour = Nb_tour;
	LDS  R30,_Nb_tour
	LDS  R31,_Nb_tour+1
	LDS  R22,_Nb_tour+2
	LDS  R23,_Nb_tour+3
	STS  _Tour,R30
	STS  _Tour+1,R31
	STS  _Tour+2,R22
	STS  _Tour+3,R23
;      96 		Vitesse = ((Nb_tour)*5);// Calcul de la vitesse 
	LDS  R26,_Nb_tour
	LDS  R27,_Nb_tour+1
	LDS  R24,_Nb_tour+2
	LDS  R25,_Nb_tour+3
	__GETD1N 0x5
	RCALL __MULD12
	STS  _Vitesse,R30
	STS  _Vitesse+1,R31
	STS  _Vitesse+2,R22
	STS  _Vitesse+3,R23
;      97 		Nb_tour = 0;		// RAZ
	LDI  R30,0
	STS  _Nb_tour,R30
	STS  _Nb_tour+1,R30
	STS  _Nb_tour+2,R30
	STS  _Nb_tour+3,R30
;      98 	} 
;      99 	refresh++;	// incrementation du compteur de rafraichissement
_0x6:
	LDS  R30,_refresh
	LDS  R31,_refresh+1
	LDS  R22,_refresh+2
	LDS  R23,_refresh+3
	__SUBD1N -1
	STS  _refresh,R30
	STS  _refresh+1,R31
	STS  _refresh+2,R22
	STS  _refresh+3,R23
;     100 	//TCNT0=0; //RAZ du compteur du timer
;     101 }  
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;     102 
;     103 
;     104 // Declare your global variables here
;     105 
;     106 void main(void)
;     107 {
_main:
;     108 
;     109 unsigned int UnitBat1 = 0;
;     110 unsigned int DecBat1 = 0;
;     111 unsigned int UnitBat2 = 0;   
;     112 unsigned int DecBat2 = 0;
;     113 
;     114 long Bat1 = 0;
;     115 long Bat2 = 0;
;     116 long Bat = 0;
;     117 
;     118 unsigned char Etat_Bat = 0;
;     119 
;     120 
;     121 
;     122 // Input/Output Ports initialization
;     123 // Port A initialization
;     124 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
;     125 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
;     126 PORTA=0x00;
	SBIW R28,15
	LDI  R24,15
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x9*2)
	LDI  R31,HIGH(_0x9*2)
	RCALL __INITLOCB
;	UnitBat1 -> R16,R17
;	DecBat1 -> R18,R19
;	UnitBat2 -> R20,R21
;	DecBat2 -> Y+13
;	Bat1 -> Y+9
;	Bat2 -> Y+5
;	Bat -> Y+1
;	Etat_Bat -> Y+0
	LDI  R16,0
	LDI  R17,0
	LDI  R18,0
	LDI  R19,0
	LDI  R20,0
	LDI  R21,0
	LDI  R30,LOW(0)
	OUT  0x1B,R30
;     127 DDRA=0x00;
	OUT  0x1A,R30
;     128 
;     129 // Port B initialization
;     130 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
;     131 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
;     132 PORTB=0x00;
	OUT  0x18,R30
;     133 DDRB=0x00;
	OUT  0x17,R30
;     134 
;     135 // Port C initialization
;     136 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
;     137 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
;     138 PORTC=0x00;
	OUT  0x15,R30
;     139 DDRC=0x00;
	OUT  0x14,R30
;     140 
;     141 // Port D initialization
;     142 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;     143 // State7=T State6=T State5=T State4=T State3=T State2=P State1=T State0=T
;     144 PORTD=0x00;
	OUT  0x12,R30
;     145 DDRD=0x00;
	OUT  0x11,R30
;     146 
;     147 // Timer/Counter 0 initialization
;     148 // Clock source: System Clock
;     149 // Clock value: 250,000 kHz
;     150 // Mode: Normal top=FFh
;     151 // OC0 output: Disconnected
;     152 TCCR0=0x03;	// F = 250kHz
	LDI  R30,LOW(3)
	OUT  0x33,R30
;     153 TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
;     154 OCR0=0xFA;	//F = 1kHz, T=1ms
	LDI  R30,LOW(250)
	OUT  0x3C,R30
;     155 
;     156 // Timer/Counter 1 initialization
;     157 // Clock source: System Clock
;     158 // Clock value: Timer 1 Stopped
;     159 // Mode: Normal top=FFFFh
;     160 // OC1A output: Discon.
;     161 // OC1B output: Discon.
;     162 // Noise Canceler: Off
;     163 // Input Capture on Falling Edge
;     164 TCCR1A=0x00;
	LDI  R30,LOW(0)
	OUT  0x2F,R30
;     165 TCCR1B=0x00;
	OUT  0x2E,R30
;     166 TCNT1H=0x00;
	OUT  0x2D,R30
;     167 TCNT1L=0x00;
	OUT  0x2C,R30
;     168 ICR1H=0x00;
	OUT  0x27,R30
;     169 ICR1L=0x00;
	OUT  0x26,R30
;     170 OCR1AH=0x00;
	OUT  0x2B,R30
;     171 OCR1AL=0x00;
	OUT  0x2A,R30
;     172 OCR1BH=0x00;
	OUT  0x29,R30
;     173 OCR1BL=0x00;
	OUT  0x28,R30
;     174 
;     175 // Timer/Counter 2 initialization
;     176 // Clock source: System Clock
;     177 // Clock value: Timer 2 Stopped
;     178 // Mode: Normal top=FFh
;     179 // OC2 output: Disconnected
;     180 ASSR=0x00;
	OUT  0x22,R30
;     181 TCCR2=0x00;
	OUT  0x25,R30
;     182 TCNT2=0x00;
	OUT  0x24,R30
;     183 OCR2=0x00;
	OUT  0x23,R30
;     184 
;     185 // External Interrupt(s) initialization
;     186 // INT0: On
;     187 // INT0 Mode: Rising Edge
;     188 // INT1: Off           
;     189 
;     190 // INT2: Off
;     191 GICR|=0x40;
	IN   R30,0x3B
	ORI  R30,0x40
	OUT  0x3B,R30
;     192 MCUCR=0x02;
	LDI  R30,LOW(2)
	OUT  0x35,R30
;     193 MCUCSR=0x00;
	LDI  R30,LOW(0)
	OUT  0x34,R30
;     194 GIFR=0x40;
	LDI  R30,LOW(64)
	OUT  0x3A,R30
;     195 
;     196 // Timer(s)/Counter(s) Interrupt(s) initialization
;     197 TIMSK=0x02;
	LDI  R30,LOW(2)
	OUT  0x39,R30
;     198 
;     199 // ADC initialization
;     200 // ADC Clock frequency: 62,500 kHz
;     201 // ADC Voltage Reference: Int., cap. on AREF
;     202 // ADC High Speed Mode: Off
;     203 // ADC Auto Trigger Source: None
;     204 ADMUX=ADC_VREF_TYPE;
	LDI  R30,LOW(192)
	OUT  0x7,R30
;     205 ADCSRA=0x87;
	LDI  R30,LOW(135)
	OUT  0x6,R30
;     206 SFIOR&=0xEF;
	IN   R30,0x30
	ANDI R30,0xEF
	OUT  0x30,R30
;     207 
;     208 // LCD module initialization
;     209 lcd_init(16);
	LDI  R30,LOW(16)
	ST   -Y,R30
	RCALL _lcd_init
;     210 
;     211 // I2C Bus initialization
;     212 i2c_init();
	RCALL _i2c_init
;     213 
;     214 // LM75 Temperature Sensor initialization
;     215 // thyst: 35C
;     216 // tos: 40C
;     217 // O.S. polarity: 0
;     218 lm75_init(CAPT1,35,40,0);
	LDI  R30,LOW(7)
	ST   -Y,R30
	LDI  R30,LOW(35)
	ST   -Y,R30
	RCALL SUBOPT_0x1
	RCALL SUBOPT_0x2
	RCALL _lm75_init
;     219 
;     220 // Global enable interrupts
;     221 #asm("sei")
	sei
;     222 
;     223 Vitesse = 0; 
	LDI  R30,0
	STS  _Vitesse,R30
	STS  _Vitesse+1,R30
	STS  _Vitesse+2,R30
	STS  _Vitesse+3,R30
;     224 refresh = 0;
	LDI  R30,0
	STS  _refresh,R30
	STS  _refresh+1,R30
	STS  _refresh+2,R30
	STS  _refresh+3,R30
;     225 Nb_tour = 0;
	LDI  R30,0
	STS  _Nb_tour,R30
	STS  _Nb_tour+1,R30
	STS  _Nb_tour+2,R30
	STS  _Nb_tour+3,R30
;     226 Tour = 0;
	LDI  R30,0
	STS  _Tour,R30
	STS  _Tour+1,R30
	STS  _Tour+2,R30
	STS  _Tour+3,R30
;     227  
;     228 lcd_gotoxy(0,0);
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x2
	RCALL _lcd_gotoxy
;     229 lcd_putsf("Projet AUTOLAV");
	__POINTW1FN _0,0
	RCALL SUBOPT_0x3
;     230 
;     231 lcd_gotoxy(10,1);
	LDI  R30,LOW(10)
	ST   -Y,R30
	RCALL SUBOPT_0x4
	RCALL _lcd_gotoxy
;     232 lcd_putsf("tr/min");
	__POINTW1FN _0,15
	RCALL SUBOPT_0x3
;     233 
;     234 Bat1 = (read_adc(BAT1)*5)/1024;
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x5
	__PUTD1S 9
;     235 Bat2 = (read_adc(BAT2)*5)/1024;
	RCALL SUBOPT_0x6
	RCALL SUBOPT_0x5
	__PUTD1S 5
;     236 
;     237 
;     238 while (1)
_0xA:
;     239       {
;     240 
;     241 		delay_ms(1000);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	RCALL SUBOPT_0x0
;     242 		  
;     243 		// Lecture valeur baterie
;     244 		UnitBat1 = (read_adc(BAT1)*26)/1024;
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0x8
	__PUTW1R 16,17
;     245 		DecBat1 = (((read_adc(BAT1)*26)%1024)*10)/1024; // * 5
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0x9
	__PUTW1R 18,19
;     246 		UnitBat2 = (read_adc(BAT2)*26)/1024;
	RCALL SUBOPT_0x6
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0x8
	__PUTW1R 20,21
;     247 		DecBat2 = (((read_adc(BAT2)*26)%1024)*10)/1024;
	RCALL SUBOPT_0x6
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0x9
	STD  Y+13,R30
	STD  Y+13+1,R31
;     248 		
;     249 		Bat1 = UnitBat1*10 + DecBat1;
	__GETW2R 16,17
	RCALL SUBOPT_0xA
	ADD  R30,R18
	ADC  R31,R19
	CLR  R22
	CLR  R23
	__PUTD1S 9
;     250 		Bat2 = UnitBat2*10 + DecBat2;
	__GETW2R 20,21
	RCALL SUBOPT_0xA
	LDD  R26,Y+13
	LDD  R27,Y+13+1
	ADD  R30,R26
	ADC  R31,R27
	CLR  R22
	CLR  R23
	__PUTD1S 5
;     251 		
;     252 		Bat = ( Bat1 + Bat2 )/2;
	__GETD2S 9
	RCALL __ADDD21
	MOVW R30,R26
	MOVW R22,R24
	RCALL __ASRD1
	__PUTD1S 1
;     253 		
;     254 		Etat_Bat = 4*Bat - 424;
	__GETD2N 0x4
	RCALL __MULD12
	__SUBD1N 424
	ST   Y,R30
;     255 		
;     256 		
;     257 		/*sprintf(Valeur,"%d   ", Tour);
;     258 		lcd_gotoxy(6,1);
;     259 		lcd_puts(Valeur);*/
;     260 		
;     261 		
;     262 		sprintf(Valeur,"%d    ", Vitesse);
	RCALL SUBOPT_0xB
	__POINTW1FN _0,22
	ST   -Y,R31
	ST   -Y,R30
	LDS  R30,_Vitesse
	LDS  R31,_Vitesse+1
	LDS  R22,_Vitesse+2
	LDS  R23,_Vitesse+3
	RCALL __PUTPARD1
	LDI  R24,4
	RCALL SUBOPT_0xC
;     263 		lcd_gotoxy(0,1);
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0xD
;     264 		lcd_puts(Valeur);
	RCALL _lcd_puts
;     265 
;     266 		sprintf(Valeur, "1:%d,%dV 2:%d,%dV  ", UnitBat1, DecBat1, UnitBat2, DecBat2);
	RCALL SUBOPT_0xB
	__POINTW1FN _0,29
	ST   -Y,R31
	ST   -Y,R30
	__GETW1R 16,17
	RCALL SUBOPT_0xE
	__GETW1R 18,19
	RCALL SUBOPT_0xE
	__GETW1R 20,21
	RCALL SUBOPT_0xE
	LDD  R30,Y+29
	LDD  R31,Y+29+1
	RCALL SUBOPT_0xE
	LDI  R24,16
	RCALL _sprintf
	ADIW R28,20
;     267 		lcd_gotoxy(0,2);
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0xF
	RCALL SUBOPT_0xD
;     268 		lcd_puts(Valeur); 
	RCALL _lcd_puts
;     269 		
;     270 		
;     271 		
;     272 		/*sprintf(Valeur, "Bat2: %d,%dV    ", Bat2, DecBat2);
;     273 		lcd_gotoxy(0,3);
;     274 		lcd_puts(Valeur);*/
;     275 		
;     276 		
;     277 
;     278 		if(((Bat1 - Bat2) > DDP) || ((Bat2 - Bat1) > DDP))
	__GETD2S 5
	__GETD1S 9
	RCALL SUBOPT_0x10
	BRLT _0xE
	__GETD2S 9
	__GETD1S 5
	RCALL SUBOPT_0x10
	BRGE _0xD
_0xE:
;     279 		{
;     280 			sprintf(Valeur, "Defaut batterie ");
	RCALL SUBOPT_0xB
	__POINTW1FN _0,49
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	RCALL SUBOPT_0x11
;     281 			lcd_gotoxy(0,3);
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x12
;     282 			lcd_puts(Valeur);		
	RCALL _lcd_puts
;     283 		}
;     284 		else if((Bat1 > 136) && (Bat2 > 136))
	RJMP _0x10
_0xD:
	__GETD2S 9
	RCALL SUBOPT_0x13
	BRGE _0x12
	__GETD2S 5
	RCALL SUBOPT_0x13
	BRLT _0x13
_0x12:
	RJMP _0x11
_0x13:
;     285 		{
;     286 			sprintf(Valeur, "En charge         ");
	RCALL SUBOPT_0xB
	__POINTW1FN _0,66
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	RCALL SUBOPT_0x11
;     287 			lcd_gotoxy(0,3);
	RJMP _0x75
;     288 			lcd_puts(Valeur);
;     289 		
;     290 		}
;     291 		else
_0x11:
;     292 		{
;     293 			sprintf(Valeur, "%d%%                ", Etat_Bat);
	RCALL SUBOPT_0xB
	__POINTW1FN _0,85
	ST   -Y,R31
	ST   -Y,R30
	LDD  R30,Y+4
	CLR  R31
	CLR  R22
	CLR  R23
	RCALL __PUTPARD1
	LDI  R24,4
	RCALL SUBOPT_0xC
;     294 			lcd_gotoxy(0,3);
_0x75:
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL SUBOPT_0x12
;     295 			lcd_puts(Valeur);
	RCALL _lcd_puts
;     296 		}
_0x10:
;     297 		
;     298 		
;     299 		
;     300 
;     301       };
	RJMP _0xA
;     302 }
	ADIW R28,15
_0x15:
	RJMP _0x15
_getchar:
     sbis usr,rxc
     rjmp _getchar
     in   r30,udr
	RET
_putchar:
     sbis usr,udre
     rjmp _putchar
     ld   r30,y
     out  udr,r30
	ADIW R28,1
	RET
__put_G2:
	put:
	RCALL SUBOPT_0x14
	SBIW R30,0
	BREQ _0x16
	RCALL SUBOPT_0x14
	ADIW R30,1
	RCALL __PUTWP1
	SBIW R30,1
	MOVW R26,R30
	LDD  R30,Y+2
	ST   X,R30
	RJMP _0x17
_0x16:
	RCALL SUBOPT_0x15
	RCALL _putchar
_0x17:
	ADIW R28,3
	RET
__print_G2:
	SBIW R28,6
	RCALL __SAVELOCR6
	LDI  R16,0
_0x18:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	ADIW R30,1
	STD  Y+16,R30
	STD  Y+16+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R19,R30
	CPI  R30,0
	BRNE PC+2
	RJMP _0x1A
	MOV  R30,R16
	CPI  R30,0
	BRNE _0x1E
	CPI  R19,37
	BRNE _0x1F
	LDI  R16,LOW(1)
	RJMP _0x20
_0x1F:
	RCALL SUBOPT_0x16
_0x20:
	RJMP _0x1D
_0x1E:
	CPI  R30,LOW(0x1)
	BRNE _0x21
	CPI  R19,37
	BRNE _0x22
	RCALL SUBOPT_0x16
	LDI  R16,LOW(0)
	RJMP _0x1D
_0x22:
	LDI  R16,LOW(2)
	LDI  R21,LOW(0)
	LDI  R17,LOW(0)
	CPI  R19,45
	BRNE _0x23
	LDI  R17,LOW(1)
	RJMP _0x1D
_0x23:
	CPI  R19,43
	BRNE _0x24
	LDI  R21,LOW(43)
	RJMP _0x1D
_0x24:
	CPI  R19,32
	BRNE _0x25
	LDI  R21,LOW(32)
	RJMP _0x1D
_0x25:
	RJMP _0x26
_0x21:
	CPI  R30,LOW(0x2)
	BRNE _0x27
_0x26:
	LDI  R20,LOW(0)
	LDI  R16,LOW(3)
	CPI  R19,48
	BRNE _0x28
	ORI  R17,LOW(128)
	RJMP _0x1D
_0x28:
	RJMP _0x29
_0x27:
	CPI  R30,LOW(0x3)
	BREQ PC+2
	RJMP _0x1D
_0x29:
	CPI  R19,48
	BRLO _0x2C
	CPI  R19,58
	BRLO _0x2D
_0x2C:
	RJMP _0x2B
_0x2D:
	MOV  R26,R20
	LDI  R30,LOW(10)
	MUL  R30,R26
	MOV  R30,R0
	MOV  R20,R30
	MOV  R30,R19
	SUBI R30,LOW(48)
	ADD  R20,R30
	RJMP _0x1D
_0x2B:
	MOV  R30,R19
	CPI  R30,LOW(0x63)
	BRNE _0x31
	RCALL SUBOPT_0x17
	LD   R30,X
	RCALL SUBOPT_0x18
	RJMP _0x32
_0x31:
	CPI  R30,LOW(0x73)
	BRNE _0x34
	RCALL SUBOPT_0x17
	RCALL SUBOPT_0x19
	RCALL _strlen
	MOV  R16,R30
	RJMP _0x35
_0x34:
	CPI  R30,LOW(0x70)
	BRNE _0x37
	RCALL SUBOPT_0x17
	RCALL SUBOPT_0x19
	RCALL _strlenf
	MOV  R16,R30
	ORI  R17,LOW(8)
_0x35:
	ORI  R17,LOW(2)
	ANDI R17,LOW(127)
	LDI  R18,LOW(0)
	RJMP _0x38
_0x37:
	CPI  R30,LOW(0x64)
	BREQ _0x3B
	CPI  R30,LOW(0x69)
	BRNE _0x3C
_0x3B:
	ORI  R17,LOW(4)
	RJMP _0x3D
_0x3C:
	CPI  R30,LOW(0x75)
	BRNE _0x3E
_0x3D:
	LDI  R30,LOW(_tbl10_G2*2)
	LDI  R31,HIGH(_tbl10_G2*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R16,LOW(5)
	RJMP _0x3F
_0x3E:
	CPI  R30,LOW(0x58)
	BRNE _0x41
	ORI  R17,LOW(8)
	RJMP _0x42
_0x41:
	CPI  R30,LOW(0x78)
	BREQ PC+2
	RJMP _0x70
_0x42:
	LDI  R30,LOW(_tbl16_G2*2)
	LDI  R31,HIGH(_tbl16_G2*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R16,LOW(4)
_0x3F:
	SBRS R17,2
	RJMP _0x44
	RCALL SUBOPT_0x17
	RCALL SUBOPT_0x1A
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	SBIW R26,0
	BRGE _0x45
	LDD  R30,Y+10
	LDD  R31,Y+10+1
	RCALL __ANEGW1
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R21,LOW(45)
_0x45:
	CPI  R21,0
	BREQ _0x46
	SUBI R16,-LOW(1)
	RJMP _0x47
_0x46:
	ANDI R17,LOW(251)
_0x47:
	RJMP _0x48
_0x44:
	RCALL SUBOPT_0x17
	RCALL SUBOPT_0x1A
_0x48:
_0x38:
	SBRC R17,0
	RJMP _0x49
_0x4A:
	CP   R16,R20
	BRSH _0x4C
	SBRS R17,7
	RJMP _0x4D
	SBRS R17,2
	RJMP _0x4E
	ANDI R17,LOW(251)
	MOV  R19,R21
	SUBI R16,LOW(1)
	RJMP _0x4F
_0x4E:
	LDI  R19,LOW(48)
_0x4F:
	RJMP _0x50
_0x4D:
	LDI  R19,LOW(32)
_0x50:
	RCALL SUBOPT_0x16
	SUBI R20,LOW(1)
	RJMP _0x4A
_0x4C:
_0x49:
	MOV  R18,R16
	SBRS R17,1
	RJMP _0x51
_0x52:
	CPI  R18,0
	BREQ _0x54
	SBRS R17,3
	RJMP _0x55
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,1
	STD  Y+6,R30
	STD  Y+6+1,R31
	SBIW R30,1
	LPM  R30,Z
	RJMP _0x76
_0x55:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R30,X+
	STD  Y+6,R26
	STD  Y+6+1,R27
_0x76:
	ST   -Y,R30
	RCALL SUBOPT_0x1B
	CPI  R20,0
	BREQ _0x57
	SUBI R20,LOW(1)
_0x57:
	SUBI R18,LOW(1)
	RJMP _0x52
_0x54:
	RJMP _0x58
_0x51:
_0x5A:
	LDI  R19,LOW(48)
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,2
	STD  Y+6,R30
	STD  Y+6+1,R31
	SBIW R30,2
	RCALL __GETW1PF
	STD  Y+8,R30
	STD  Y+8+1,R31
                                      ldd  r26,y+10  ;R26,R27=n
                                      ldd  r27,y+11
                                  calc_digit:
                                      cp   r26,r30
                                      cpc  r27,r31
                                      brlo calc_digit_done
	SUBI R19,-LOW(1)
	                                  sub  r26,r30
	                                  sbc  r27,r31
	                                  brne calc_digit
                                  calc_digit_done:
                                      std  Y+10,r26 ;n=R26,R27
                                      std  y+11,r27
	LDI  R30,LOW(57)
	CP   R30,R19
	BRSH _0x5C
	SBRS R17,3
	RJMP _0x5D
	SUBI R19,-LOW(7)
	RJMP _0x5E
_0x5D:
	SUBI R19,-LOW(39)
_0x5E:
_0x5C:
	SBRC R17,4
	RJMP _0x60
	LDI  R30,LOW(48)
	CP   R30,R19
	BRLO _0x62
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	CPI  R26,LOW(0x1)
	LDI  R30,HIGH(0x1)
	CPC  R27,R30
	BRNE _0x61
_0x62:
	ORI  R17,LOW(16)
	RJMP _0x64
_0x61:
	CP   R20,R18
	BRLO _0x66
	SBRS R17,0
	RJMP _0x67
_0x66:
	RJMP _0x65
_0x67:
	LDI  R19,LOW(32)
	SBRS R17,7
	RJMP _0x68
	LDI  R19,LOW(48)
	ORI  R17,LOW(16)
_0x64:
	SBRS R17,2
	RJMP _0x69
	ANDI R17,LOW(251)
	ST   -Y,R21
	RCALL SUBOPT_0x1B
	CPI  R20,0
	BREQ _0x6A
	SUBI R20,LOW(1)
_0x6A:
_0x69:
_0x68:
_0x60:
	RCALL SUBOPT_0x16
	CPI  R20,0
	BREQ _0x6B
	SUBI R20,LOW(1)
_0x6B:
_0x65:
	SUBI R18,LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	CP   R30,R26
	CPC  R31,R27
	BRSH _0x5B
	RJMP _0x5A
_0x5B:
_0x58:
	SBRS R17,0
	RJMP _0x6C
_0x6D:
	CPI  R20,0
	BREQ _0x6F
	SUBI R20,LOW(1)
	LDI  R30,LOW(32)
	RCALL SUBOPT_0x18
	RJMP _0x6D
_0x6F:
_0x6C:
_0x70:
_0x32:
	LDI  R16,LOW(0)
_0x1D:
	RJMP _0x18
_0x1A:
	RCALL __LOADLOCR6
	ADIW R28,18
	RET
_sprintf:
	MOV  R15,R24
	SBIW R28,2
	RCALL __SAVELOCR2
	MOVW R26,R28
	RCALL __ADDW2R15
	__PUTW2R 16,17
	MOVW R26,R28
	ADIW R26,6
	RCALL SUBOPT_0x1C
	STD  Y+2,R30
	STD  Y+2+1,R31
	MOVW R26,R28
	ADIW R26,4
	RCALL SUBOPT_0x1C
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	RCALL __print_G2
	LDD  R26,Y+2
	LDD  R27,Y+2+1
	LDI  R30,LOW(0)
	ST   X,R30
	RCALL __LOADLOCR2
	ADIW R28,4
	RET
_lm75_set_temp:
	RCALL _i2c_start
	RCALL SUBOPT_0x15
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x1E
	LD   R30,Y
	RCALL SUBOPT_0x1E
	RCALL SUBOPT_0x2
	RCALL _i2c_write
	RCALL _i2c_stop
	ADIW R28,3
	RET
_lm75_init:
	ST   -Y,R16
	LDD  R30,Y+4
	LSL  R30
	ORI  R30,LOW(0x90)
	MOV  R16,R30
	RCALL _i2c_start
	ST   -Y,R16
	RCALL _i2c_write
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x1D
	LSL  R30
	LSL  R30
	RCALL SUBOPT_0x1E
	RCALL _i2c_stop
	ST   -Y,R16
	RCALL SUBOPT_0xF
	LDD  R30,Y+5
	RCALL SUBOPT_0x1F
	ST   -Y,R16
	LDI  R30,LOW(3)
	ST   -Y,R30
	LDD  R30,Y+4
	RCALL SUBOPT_0x1F
	LDD  R16,Y+0
	ADIW R28,5
	RET
    .equ __lcd_direction=__lcd_port-1
    .equ __lcd_pin=__lcd_port-2
    .equ __lcd_rs=0
    .equ __lcd_rd=1
    .equ __lcd_enable=2
    .equ __lcd_busy_flag=7

	.DSEG
__base_y_G4:
	.BYTE 0x4

	.CSEG
__lcd_ready:
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
    cbi   __lcd_port,__lcd_rs     ;RS=0
__lcd_busy:
    rcall __lcd_delay
    sbi   __lcd_port,__lcd_enable ;EN=1
    rcall __lcd_delay
    in    r26,__lcd_pin
    cbi   __lcd_port,__lcd_enable ;EN=0
    rcall __lcd_delay
    sbi   __lcd_port,__lcd_enable ;EN=1
    rcall __lcd_delay
    cbi   __lcd_port,__lcd_enable ;EN=0
    sbrc  r26,__lcd_busy_flag
    rjmp  __lcd_busy
	RET
__lcd_write_nibble:
    andi  r26,0xf0
    or    r26,r27
    out   __lcd_port,r26          ;write
    sbi   __lcd_port,__lcd_enable ;EN=1
    rcall __lcd_delay
    cbi   __lcd_port,__lcd_enable ;EN=0
__lcd_delay:
    ldi   r31,15
__lcd_delay0:
    dec   r31
    brne  __lcd_delay0
    ret
__lcd_write_data:
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf7                ;set as output
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
    rcall __lcd_write_nibble      ;RD=0, write MSN
    ld    r26,y
    swap  r26
    rcall __lcd_write_nibble      ;write LSN
    sbi   __lcd_port,__lcd_rd     ;RD=1
	ADIW R28,1
	RET
__lcd_read_nibble:
    sbi   __lcd_port,__lcd_enable ;EN=1
    rcall __lcd_delay
    in    r30,__lcd_pin           ;read
    cbi   __lcd_port,__lcd_enable ;EN=0
    rcall __lcd_delay
    andi  r30,0xf0
    ret
_lcd_read_byte0_G4:
    rcall __lcd_delay
    rcall __lcd_read_nibble       ;read MSN
    mov   r26,r30
    rcall __lcd_read_nibble       ;read LSN
    cbi   __lcd_port,__lcd_rd     ;RD=0
    swap  r30
    or    r30,r26
	RET
_lcd_gotoxy:
	RCALL __lcd_ready
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-__base_y_G4)
	SBCI R31,HIGH(-__base_y_G4)
	LD   R30,Z
	LDD  R26,Y+1
	ADD  R30,R26
	RCALL SUBOPT_0x20
	LDD  R4,Y+1
	LDD  R5,Y+0
	ADIW R28,2
	RET
_lcd_clear:
	RCALL __lcd_ready
	RCALL SUBOPT_0xF
	RCALL __lcd_write_data
	RCALL __lcd_ready
	LDI  R30,LOW(12)
	RCALL SUBOPT_0x20
	RCALL __lcd_ready
	RCALL SUBOPT_0x4
	RCALL __lcd_write_data
	LDI  R30,LOW(0)
	MOV  R5,R30
	MOV  R4,R30
	RET
_lcd_putchar:
    push r30
    push r31
    ld   r26,y
    set
    cpi  r26,10
    breq __lcd_putchar1
    clt
	INC  R4
	CP   R6,R4
	BRSH _0x72
	__lcd_putchar1:
	INC  R5
	RCALL SUBOPT_0x2
	ST   -Y,R5
	RCALL _lcd_gotoxy
	brts __lcd_putchar0
_0x72:
    rcall __lcd_ready
    sbi  __lcd_port,__lcd_rs ;RS=1
    ld   r26,y
    st   -y,r26
    rcall __lcd_write_data
__lcd_putchar0:
    pop  r31
    pop  r30
	ADIW R28,1
	RET
_lcd_puts:
    ldd  r31,y+1
    ld   r30,y
__lcd_puts0:
    ld   r26,z+
    tst  r26
    breq __lcd_puts1
    st   -y,r26    
    rcall _lcd_putchar
    rjmp __lcd_puts0
__lcd_puts1:
	ADIW R28,2
	RET
_lcd_putsf:
    ld   r30,y
    ldd  r31,y+1
__lcd_putsf0:
	lpm
    tst  r0
    breq __lcd_putsf1
    adiw r30,1
    st   -y,r0
    rcall _lcd_putchar
    rjmp __lcd_putsf0
__lcd_putsf1:
	ADIW R28,2
	RET
__long_delay_G4:
    clr   r26
    clr   r27
__long_delay0:
    sbiw  r26,1         ;2 cycles
    brne  __long_delay0 ;2 cycles
	RET
__lcd_init_write_G4:
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf7                ;set as output
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
    rcall __lcd_write_nibble      ;RD=0, write MSN
    sbi   __lcd_port,__lcd_rd     ;RD=1
	ADIW R28,1
	RET
_lcd_init:
    cbi   __lcd_port,__lcd_enable ;EN=0
    cbi   __lcd_port,__lcd_rs     ;RS=0
	LDD  R6,Y+0
	LD   R30,Y
	SUBI R30,-LOW(128)
	__PUTB1MN __base_y_G4,2
	LD   R30,Y
	SUBI R30,-LOW(192)
	__PUTB1MN __base_y_G4,3
	RCALL SUBOPT_0x21
	RCALL SUBOPT_0x21
	RCALL SUBOPT_0x21
	RCALL __long_delay_G4
	LDI  R30,LOW(32)
	ST   -Y,R30
	RCALL __lcd_init_write_G4
	RCALL __long_delay_G4
	RCALL SUBOPT_0x1
	RCALL __lcd_write_data
	RCALL __long_delay_G4
	LDI  R30,LOW(4)
	RCALL SUBOPT_0x20
	RCALL __long_delay_G4
	LDI  R30,LOW(133)
	RCALL SUBOPT_0x20
	RCALL __long_delay_G4
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
	RCALL _lcd_read_byte0_G4
	CPI  R30,LOW(0x5)
	BREQ _0x73
	LDI  R30,LOW(0)
	RJMP _0x74
_0x73:
	RCALL __lcd_ready
	RCALL SUBOPT_0x6
	RCALL __lcd_write_data
	RCALL _lcd_clear
	LDI  R30,LOW(1)
_0x74:
	ADIW R28,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x0:
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1:
	LDI  R30,LOW(40)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES
SUBOPT_0x2:
	LDI  R30,LOW(0)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x3:
	ST   -Y,R31
	ST   -Y,R30
	RJMP _lcd_putsf

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES
SUBOPT_0x4:
	LDI  R30,LOW(1)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x5:
	RCALL _read_adc
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	RCALL __MULW12U
	RCALL __LSRW2
	MOV  R30,R31
	LDI  R31,0
	CLR  R22
	CLR  R23
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x6:
	LDI  R30,LOW(6)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x7:
	RCALL _read_adc
	LDI  R26,LOW(26)
	LDI  R27,HIGH(26)
	RCALL __MULW12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x8:
	RCALL __LSRW2
	MOV  R30,R31
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x9:
	ANDI R31,HIGH(0x3FF)
	LDI  R26,LOW(10)
	LDI  R27,HIGH(10)
	RCALL __MULW12U
	RJMP SUBOPT_0x8

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0xA:
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RCALL __MULW12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES
SUBOPT_0xB:
	LDI  R30,LOW(_Valeur)
	LDI  R31,HIGH(_Valeur)
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0xC:
	RCALL _sprintf
	ADIW R28,8
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0xD:
	RCALL _lcd_gotoxy
	RJMP SUBOPT_0xB

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0xE:
	CLR  R22
	CLR  R23
	RCALL __PUTPARD1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0xF:
	LDI  R30,LOW(2)
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x10:
	RCALL __SUBD12
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0xA
	RCALL __CPD12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x11:
	RCALL _sprintf
	ADIW R28,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x12:
	LDI  R30,LOW(3)
	ST   -Y,R30
	RJMP SUBOPT_0xD

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x13:
	__GETD1N 0x88
	RCALL __CPD12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x14:
	LD   R26,Y
	LDD  R27,Y+1
	RCALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x15:
	LDD  R30,Y+2
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x16:
	ST   -Y,R19
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	RJMP __put_G2

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES
SUBOPT_0x17:
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	SBIW R26,4
	STD  Y+14,R26
	STD  Y+14+1,R27
	ADIW R26,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x18:
	ST   -Y,R30
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	RJMP __put_G2

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x19:
	RCALL __GETD1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1A:
	RCALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1B:
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	RJMP __put_G2

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1C:
	RCALL __ADDW2R15
	RCALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1D:
	RCALL _i2c_write
	LDD  R30,Y+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x1E:
	ST   -Y,R30
	RJMP _i2c_write

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1F:
	ST   -Y,R30
	RJMP _lm75_set_temp

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x20:
	ST   -Y,R30
	RJMP __lcd_write_data

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x21:
	RCALL __long_delay_G4
	LDI  R30,LOW(48)
	ST   -Y,R30
	RJMP __lcd_init_write_G4

	.equ __i2c_dir=__i2c_port-1
	.equ __i2c_pin=__i2c_port-2
_i2c_init:
	cbi  __i2c_port,__scl_bit
	cbi  __i2c_port,__sda_bit
	sbi  __i2c_dir,__scl_bit
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_delay2
_i2c_start:
	cbi  __i2c_dir,__sda_bit
	cbi  __i2c_dir,__scl_bit
	clr  r30
	nop
	sbis __i2c_pin,__sda_bit
	ret
	sbis __i2c_pin,__scl_bit
	ret
	rcall __i2c_delay1
	sbi  __i2c_dir,__sda_bit
	rcall __i2c_delay1
	sbi  __i2c_dir,__scl_bit
	ldi  r30,1
__i2c_delay1:
	ldi  r22,27
	rjmp __i2c_delay2l
_i2c_stop:
	sbi  __i2c_dir,__sda_bit
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__sda_bit
__i2c_delay2:
	ldi  r22,53
__i2c_delay2l:
	dec  r22
	brne __i2c_delay2l
	ret
_i2c_read:
	ldi  r23,8
__i2c_read0:
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	clc
	sbic __i2c_pin,__sda_bit
	sec
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	rol  r30
	dec  r23
	brne __i2c_read0
	ld   r23,y+
	tst  r23
	brne __i2c_read1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_read2
__i2c_read1:
	sbi  __i2c_dir,__sda_bit
__i2c_read2:
	rcall __i2c_delay1
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	sbi  __i2c_dir,__scl_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_delay1

_i2c_write:
	ld   r30,y+
	ldi  r23,8
__i2c_write0:
	lsl  r30
	brcc __i2c_write1
	cbi  __i2c_dir,__sda_bit
	rjmp __i2c_write2
__i2c_write1:
	sbi  __i2c_dir,__sda_bit
__i2c_write2:
	rcall __i2c_delay2
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	sbi  __i2c_dir,__scl_bit
	dec  r23
	brne __i2c_write0
	cbi  __i2c_dir,__sda_bit
	rcall __i2c_delay1
	cbi  __i2c_dir,__scl_bit
	rcall __i2c_delay2
	ldi  r30,1
	sbic __i2c_pin,__sda_bit
	clr  r30
	sbi  __i2c_dir,__scl_bit
	ret

_strlen:
	ld   r26,y+
	ld   r27,y+
	clr  r30
	clr  r31
__strlen0:
	ld   r22,x+
	tst  r22
	breq __strlen1
	adiw r30,1
	rjmp __strlen0
__strlen1:
	ret

_strlenf:
	clr  r26
	clr  r27
	ld   r30,y+
	ld   r31,y+
__strlenf0:
	lpm  r0,z+
	tst  r0
	breq __strlenf1
	adiw r26,1
	rjmp __strlenf0
__strlenf1:
	movw r30,r26
	ret

_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0xFA0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDW2R15:
	CLR  R0
	ADD  R26,R15
	ADC  R27,R0
	RET

__ADDD21:
	ADD  R26,R30
	ADC  R27,R31
	ADC  R24,R22
	ADC  R25,R23
	RET

__SUBD12:
	SUB  R30,R26
	SBC  R31,R27
	SBC  R22,R24
	SBC  R23,R25
	RET

__ANEGW1:
	COM  R30
	COM  R31
	ADIW R30,1
	RET

__ANEGD1:
	COM  R30
	COM  R31
	COM  R22
	COM  R23
	SUBI R30,-1
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__ASRD1:
	ASR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	RET

__LSRW2:
	LSR  R31
	ROR  R30
	LSR  R31
	ROR  R30
	RET

__MULW12U:
	MUL  R31,R26
	MOV  R31,R0
	MUL  R30,R27
	ADD  R31,R0
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	RET

__MULD12U:
	MUL  R23,R26
	MOV  R23,R0
	MUL  R22,R27
	ADD  R23,R0
	MUL  R31,R24
	ADD  R23,R0
	MUL  R30,R25
	ADD  R23,R0
	MUL  R22,R26
	MOV  R22,R0
	ADD  R23,R1
	MUL  R31,R27
	ADD  R22,R0
	ADC  R23,R1
	MUL  R30,R24
	ADD  R22,R0
	ADC  R23,R1
	CLR  R24
	MUL  R31,R26
	MOV  R31,R0
	ADD  R22,R1
	ADC  R23,R24
	MUL  R30,R27
	ADD  R31,R0
	ADC  R22,R1
	ADC  R23,R24
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	ADC  R22,R24
	ADC  R23,R24
	RET

__MULD12:
	RCALL __CHKSIGND
	RCALL __MULD12U
	BRTC __MULD121
	RCALL __ANEGD1
__MULD121:
	RET

__CHKSIGND:
	CLT
	SBRS R23,7
	RJMP __CHKSD1
	RCALL __ANEGD1
	SET
__CHKSD1:
	SBRS R25,7
	RJMP __CHKSD2
	CLR  R0
	COM  R26
	COM  R27
	COM  R24
	COM  R25
	ADIW R26,1
	ADC  R24,R0
	ADC  R25,R0
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSD2:
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETD1P:
	LD   R30,X+
	LD   R31,X+
	LD   R22,X+
	LD   R23,X
	SBIW R26,3
	RET

__PUTWP1:
	ST   X+,R30
	ST   X,R31
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__CPD20:
	SBIW R26,0
	SBCI R24,0
	SBCI R25,0
	RET

__CPD12:
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	CPC  R23,R25
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

__INITLOCB:
__INITLOCW:
	ADD R26,R28
	ADC R27,R29
__INITLOC0:
	LPM  R0,Z+
	ST   X+,R0
	DEC  R24
	BRNE __INITLOC0
	RET

